<?php

declare( strict_types=1 );

namespace ga_gtag_manager\includes\ui;

if ( ! class_exists( 'ga_gtag_manager\includes\ui\Ga_Manager_ACF_Loader' ) ) {
	class Ga_Manager_ACF_Loader {

		public function __construct() {
		}

		public static function init(): void {
			if ( function_exists( 'acf_add_options_page' ) ) {
				acf_add_options_page( array(
					'page_title' => 'Google Analytics Settings',
					'menu_title' => 'GA4 Settings',
					'menu_slug'  => 'ga-manager-settings',
					'capability' => 'manage_options',
					'redirect'   => false
				) );

				acf_add_options_sub_page( array(
					'page_title'  => 'Google Tag Manager Settings',
					'menu_title'  => 'GTag Settings',
					'menu_slug'   => 'gtag-settings',
					'capability'  => 'manage_options',
					'parent_slug' => 'ga-manager-settings',
				) );
			}

			if ( function_exists( 'acf_add_local_field_group' ) ) {

				acf_add_local_field_group( array(
					'key'                   => 'ga_group',
					'title'                 => 'Google Analytics',
					'fields'                => array(
						array(
							'key'    => 'ga_scripts_repeater_field',
							'label'  => 'Google Analytics Scripts',
							'name'   => 'ga_scripts',
							'wpml_cf_preferences' => 1,
							'type'   => 'repeater',
							'layout' => 'row',
						)
					),
					'location'              => array(
						array(
							array(
								'param'    => 'options_page',
								'operator' => '==',
								'value'    => 'ga-manager-settings',
							),
						),
					),
					'menu_order'            => 0,
					'position'              => 'normal',
					'style'                 => 'default',
					'label_placement'       => 'top',
					'instruction_placement' => 'label',
				) );

				acf_add_local_field_group( array(
					'key'                   => 'gtag_group',
					'title'                 => 'Google Tag Manager',
					'fields'                => array(
						array(
							'key'    => 'gtm_scripts_repeater_field',
							'label'  => 'Google Tag Manager Scripts',
							'wpml_cf_preferences' => 1,
							'name'   => 'gtm_scripts',
							'type'   => 'repeater',
							'layout' => 'row',
						)
					),
					'location'              => array(
						array(
							array(
								'param'    => 'options_page',
								'operator' => '==',
								'value'    => 'gtag-settings',
							),
						),
					),
					'menu_order'            => 0,
					'position'              => 'normal',
					'style'                 => 'default',
					'label_placement'       => 'top',
					'instruction_placement' => 'label',
					'hide_on_screen'        => '',
				) );

			}

			if ( function_exists( 'acf_add_local_field' ) ) {

				/* Google Analytics fields */

				acf_add_local_field( array(
					'key'      => 'ga_script_text_field',
					'label'    => 'Google Analytics Script',
					'name'     => 'ga_script',
					'wpml_cf_preferences' => 1,
					'type'     => 'textarea',
					'required' => 1,
					'parent'   => 'ga_scripts_repeater_field'
				) );

				acf_add_local_field( array(
					'key'           => 'ga_dont_show_on_post_object',
					'label'         => 'Don\'t show on',
					'name'          => 'ga_dont_show_on',
					'wpml_cf_preferences' => 1,
					'type'          => 'post_object',
					'post_type'     => [ 'page', 'wffn_ty' ],
					'status'        => [ 'publish' ],
					'return_format' => 'id',
					'multiple'      => 1,
					'parent'        => 'ga_scripts_repeater_field'
				) );

				acf_add_local_field( array(
					'key'    => 'ga_script_enabled_checkbox_field',
					'label'  => 'Enabled?',
					'name'   => 'ga_script_enabled',
					'wpml_cf_preferences' => 1,
					'type'   => 'true_false',
					'parent' => 'ga_scripts_repeater_field'
				) );

				/* Google tag manager Fields */

				acf_add_local_field( array(
					'key'      => 'gtm_script_text_field',
					'label'    => 'Google Tag Manager Script',
					'name'     => 'gtm_script',
					'type'     => 'textarea',
					'wpml_cf_preferences' => 1,
					'required' => 1,
					'parent'   => 'gtm_scripts_repeater_field'
				) );

				acf_add_local_field( array(
					'key'      => 'gtm_noscript_text_field',
					'label'    => 'Google Tag Manager no script',
					'name'     => 'gtm_noscript',
					'type'     => 'textarea',
					'wpml_cf_preferences' => 1,
					'required' => 1,
					'parent'   => 'gtm_scripts_repeater_field'
				) );

				acf_add_local_field( array(
					'key'           => 'gtm_dont_show_on_post_object',
					'label'         => 'Don\'t show on',
					'name'          => 'gtm_dont_show_on',
					'type'          => 'post_object',
					'post_type'     => [ 'page', 'wffn_ty' ],
					'status'        => [ 'publish' ],
					'return_format' => 'id',
					'wpml_cf_preferences' => 1,
					'multiple'      => 1,
					'parent'        => 'gtm_scripts_repeater_field'
				) );

				acf_add_local_field( array(
					'key'    => 'gtm_script_enabled_checkbox_field',
					'label'  => 'Enabled?',
					'name'   => 'gtm_script_enabled',
					'wpml_cf_preferences' => 1,
					'type'   => 'true_false',
					'parent' => 'gtm_scripts_repeater_field'
				) );

			}
		}

	}
}