<?php

declare( strict_types=1 );

namespace ga_gtag_manager\includes;

if ( ! class_exists( 'ga_gtag_manager\includes\Ga_Manager_Core' ) ) {
	class Ga_Manager_Core {

		public function init_actions(): void {
			add_action('acf/save_post', [$this, 'acf_on_save_gtm_or_ga_scripts']);

			add_action( 'wp_head', [ $this, 'add_ga_code_from_acf_in_head' ] );

			add_action( 'wp_head', [ $this, 'add_gtm_code_from_acf_in_head' ] );
			add_action( 'wp_body_open', [ $this, 'acf_show_gtm_no_script' ] );

			// Заделка под кастомные ивенты для GTM, пока закоментил что бы не тянулся пустой скрипт
			// add_action( 'wp_enqueue_scripts', [ $this, 'load_gtm_events_js' ] );
		}

		public function add_ga_code_from_acf_in_head(): void {
			if ( have_rows( 'ga_scripts_repeater_field', 'option' ) ) {
				while ( have_rows( 'ga_scripts_repeater_field', 'option' ) ) : the_row();
					if ( get_sub_field( 'ga_script_enabled_checkbox_field' ) === true ) {
						if ( !get_sub_field( 'ga_dont_show_on_post_object' ) || ! in_array( get_the_ID(), get_sub_field( 'ga_dont_show_on_post_object' ) ) ) {
							echo get_sub_field( 'ga_script_text_field' );
						}
					}
				endwhile;
			}
		}

		public function add_gtm_code_from_acf_in_head(): void {
			if ( have_rows( 'gtm_scripts_repeater_field', 'option' ) ) {
				while ( have_rows( 'gtm_scripts_repeater_field', 'option' ) ) : the_row();
					if ( get_sub_field( 'gtm_script_enabled_checkbox_field' ) === true ) {
						if ( !get_sub_field( 'gtm_dont_show_on_post_object' ) || ! in_array( get_the_ID(), get_sub_field( 'gtm_dont_show_on_post_object' ) ) ) {
							echo get_sub_field( 'gtm_script_text_field' );
						}
					}
				endwhile;
			}
		}

		public function acf_show_gtm_no_script(): void {
			if ( have_rows( 'gtm_scripts_repeater_field', 'option' ) ) {
				while ( have_rows( 'gtm_scripts_repeater_field', 'option' ) ) : the_row();
					if ( get_sub_field( 'gtm_script_enabled_checkbox_field' ) === true ) {
						if ( !get_sub_field( 'gtm_dont_show_on_post_object' ) || ! in_array( get_the_ID(), get_sub_field( 'gtm_dont_show_on_post_object' ) ) ) {
							echo get_sub_field( 'gtm_noscript_text_field' );
						}
					}
				endwhile;
			}
		}

		public function load_gtm_events_js(): void {
			wp_enqueue_script(
				'gtag-events-script',
				plugin_dir_url( __FILE__ ) . 'assets/js/gtag_events.js',
				array( 'jquery' ),
				'1.0.0',
				true
			);
		}

		public function acf_on_save_gtm_or_ga_scripts(string|int $post_id): void {
			if ($post_id === 'options' && isset($_POST['acf'])) {
				$this->flush_cache($_POST['acf']);
			}
		}

		private function flush_cache(array $acf_data): void {
			if (isset($acf_data['ga_scripts_repeater_field']) || isset($acf_data['gtm_scripts_repeater_field'])) {
				if (function_exists('wp_cache_flush')) {
					wp_cache_flush();

					if (class_exists('cloudflare_purge_cache\includes\Cloudflare_Purge_Cache_Core')) {
						\cloudflare_purge_cache\includes\Cloudflare_Purge_Cache_Core::purge_cache();
					}
				}
			}
		}

	}
}