<?php
if ( ! class_exists( 'WFOB_Layout_5' ) ) {
	class WFOB_Layout_5 extends WFOB_Bump {
		protected static $slug = 'layout_5';

		public function __construct( $wfob_id ) {
			parent::__construct( $wfob_id );
		}

		/**
		 * Get Default Setting of bump
		 * @return string
		 */
		public static function get_slug() {
			return self::$slug;
		}

		/**
		 * Get preview image url
		 * @return string
		 */
		public static function get_preview_image_url() {
			return WFOB_PLUGIN_URL . '/assets/img/skin-5.jpg';
		}

		public function get_admin_schema() {
			return parent::get_admin_schema();
		}

		public static function get_default_models() {
			return array(
				'heading_background'        => '',
				'heading_hover_background'  => '',
				'heading_font_size'         => '14',
				'heading_color'             => '#09B29C',
				'heading_hover_color'       => '',
				'heading_box_padding'       => '6 12 6 12',
				'heading_box_border_style'  => 'solid',
				'heading_box_border_color'  => '#dedfea',
				'heading_box_border_width'  => '1 1 1 1',
				'heading_box_border_radius' => '4',

				'header_enable_pointing_arrow' => true,
				'point_animation'              => '1',
				'point_animation_color'        => '#D80027',

				'error_color' => '#E20707',

				'enable_featured_image_border' => 'true',
				'featured_image_border_width'  => '1',
				'featured_image_border_style'  => 'solid',
				'featured_image_border_color'  => '#ECECEC',
				'featured_image_border_radius' => '8',

				'content_font_size'                  => '14',
				'content_color'                      => '#353030',
				'content_variation_link_color'       => '#e15334',
				'content_variation_link_hover_color' => '',
				'content_box_padding'                => '0',

				'enable_price'    => true,
				'price_font_size' => '12',
				'price_color'     => '#353030',

				'price_sale_font_size' => '',
				'price_sale_color'     => '',


				'box_background'       => '#EFF5FF',
				'box_background_hover' => '',
				'box_padding'          => "16",
				'enable_box_border'    => 'true',
				'border_style'         => 'solid',
				'border_color'         => '#82A6DA',
				'border_width'         => '1',
				'box_border_radius'    => '8',

				'bump_max_width' => '',

				'exclusive_content_font_size' => '12',
				'exclusive_content_color'     => '#09B29C',
				'exclusive_content_enable'    => 'false',
				'exclusive_content'           => __( 'Exclusive Offer', 'woofunnels-order-bump' ),
				'exclusive_content_position'  => 'wfob_exclusive_above_description',

				'layout'      => 'layout_5',
				'layout_name' => __( 'Skin 5', 'woofunnels-order-bump' ),
				'class_name'  => 'WFOB_Layout_5',

			'product_title'                => __( "<span style='color:#E15334'>Yes!</span> Add ", 'woofunnels-order-bump' ) . '{{product_name}}' . __( ' to my order', 'woofunnels-order-bump' ),
			'product_featured_image'       => true,
			'product_description'          => __( "Aperiam consecttur quisquam Aperiam consectetur. Lorem Ipsum is simply dummy text of the printing and typesetting industry.", 'woofunnels-order-bump' ),
			'product_image_url'            => WFOB_PLUGIN_URL . '/admin/assets/img/preview_bump_product_icon.jpg',
			'product_image_position_class' => 'wfob_img_position_left',
			'product_image_position_width' => '96',
			'product_image_position'       => 'center',
			'product_price'                => wc_format_sale_price( 39.97, 35.67 ),
			'product_price_numeric'        => '35.67',


			);
		}

	}


	WFOB_Bump_Fc::register( 'WFOB_Layout_5' );
}