<?php
if ( ! class_exists( 'WFOB_YayCurrency' ) ) {
	/**
	 * YayCurrency – WooCommerce Multi-Currency Switcher
	 * https://wordpress.org/plugins/yaycurrency/
	 */
	class WFOB_YayCurrency {
		public function __construct() {
			add_filter( 'wfob_set_bump_product_price_params', [ $this, 'do_not_set_bump_prices' ] );
			add_filter( 'wfob_product_switcher_price_data', [ $this, 'change_price' ], 20, 2 );
		}

		public function do_not_set_bump_prices() {
			return false;
		}

		public function change_price( $price_data, $pro ) {
			$price_data['regular_org'] = $pro->get_regular_price();
			$price_data['price']       = $pro->get_price();

			return $price_data;
		}
	}

	new WFOB_YayCurrency();
}