<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( ! class_exists( 'WFOB_Compatibility_With_WooMulti_Curcy' ) ) {
	class WFOB_Compatibility_With_WooMulti_Curcy {
		private $woo_multi_currency_data = null;

		public function __construct() {
			add_filter( 'wfob_product_raw_data', [ $this, 'wfacp_product_raw_data' ], 10, 2 );
			add_filter( 'wfob_product_switcher_price_data', [ $this, 'convert_discounted_price' ], 10, 2 );
		}

		/**
		 * Convert Local Product Pricing currency
		 *
		 * @param $raw_data
		 * @param $product WC_Product;
		 *
		 * @return mixed
		 */
		public function wfacp_product_raw_data( $raw_data, $product ) {
			if ( ! function_exists( 'wmc_get_price' ) ) {
				return $raw_data;
			}
			$settings = $this->get_currency_instance();

			if ( is_null( $settings ) ) {
				return $raw_data;
			}

			$current_currency = $settings->get_current_currency();
			$default_currency = $settings->get_default_currency();
			if ( $current_currency == $default_currency ) {
				return $raw_data;
			}


			$regular_price_wmcp = json_decode( get_post_meta( $product->get_id(), '_regular_price_wmcp', true ), true );
			$sale_price_wmcp    = json_decode( get_post_meta( $product->get_id(), '_sale_price_wmcp', true ), true );
			if ( ! isset( $regular_price_wmcp[ $current_currency ] ) || $regular_price_wmcp[ $current_currency ] < 0 ) {


				$raw_data['regular_price'] = wmc_get_price( $raw_data['regular_price'], $current_currency );
				$raw_data['price']         = wmc_get_price( $raw_data['price'], $current_currency );

				return $raw_data;
			}


			/**
			 * If Regular Price Available in different Currency the use Direct value.
			 */
			if ( isset( $regular_price_wmcp[ $current_currency ] ) ) {
				$raw_data['regular_price'] = $regular_price_wmcp[ $current_currency ];
				if ( $raw_data['regular_price'] > 0 ) {
					$sale_price = ! is_null( $sale_price_wmcp ) && isset( $sale_price_wmcp[ $current_currency ] ) ? $sale_price_wmcp[ $current_currency ] : 0;
					if ( $sale_price > 0 ) {
						$raw_data['price']      = $sale_price;
						$raw_data['sale_price'] = $sale_price;
					} else {
						$raw_data['price'] = $raw_data['regular_price'];
					}
				}
			}

			return $raw_data;
		}


		/**
		 * @return WOOMULTI_CURRENCY_Data OR WOOMULTI_CURRENCY_F_Data
		 */
		private function get_currency_instance() {
			if ( is_null( $this->woo_multi_currency_data ) && class_exists( 'WOOMULTI_CURRENCY_Data' ) ) {
				$this->woo_multi_currency_data = WOOMULTI_CURRENCY_Data::get_ins();
			}

			if ( is_null( $this->woo_multi_currency_data ) && class_exists( 'WOOMULTI_CURRENCY_F_Data' ) ) {
				$this->woo_multi_currency_data = WOOMULTI_CURRENCY_F_Data::get_ins();
			}

			return $this->woo_multi_currency_data;
		}

		/**
		 * @param $price_data
		 * @param $product WC_Product
		 *
		 * @return mixed
		 */
		public function convert_discounted_price( $price_data, $product ) {
			if ( ! function_exists( 'wmc_get_price' ) ) {
				return $price_data;
			}

			$price_data['regular_org'] = $product->get_regular_price( 'edit' );
			$price_data['price']       = $product->get_price( 'edit' );
			if ( class_exists( 'WOOMULTI_CURRENCY_Plugin_Woofunnels_Order_Bump' ) ) {
				WFOB_Common::remove_actions( 'wfob_show_product_price', 'WOOMULTI_CURRENCY_Plugin_Woofunnels_Order_Bump', 'wfob_show_product_price' );
			}
			if ( class_exists( 'WOOMULTI_CURRENCY_F_Plugin_Woofunnels_Order_Bump' ) ) {
				WFOB_Common::remove_actions( 'wfob_show_product_price', 'WOOMULTI_CURRENCY_F_Plugin_Woofunnels_Order_Bump', 'wfob_show_product_price' );
			}

			return $price_data;
		}


	}

	new WFOB_Compatibility_With_WooMulti_Curcy();
}