<?php
if ( ! class_exists( 'WFACP_Pre_Built' ) ) {
	#[AllowDynamicProperties]
	class WFACP_Pre_Built extends WFACP_Template_Common {
		protected $sidebar_layout_order = [];
		protected $mobile_layout_order = [];
		public $customizer_fields = [];
		public $customizer_fields_data = [];
		protected $layout_setting = [];
		protected $internal_css = [];
		public $customizer_css = [];
		protected $customizer_data = [];
		protected $sections = array( 'wfacp_section' );
		protected $section_keys_data = [];
		protected $current_active_sidebar = [];
		protected $excluded_sidebar_sections = [];
		public $excluded_layout_sections_sidebar = [];
		protected $checkout_buttons = [];
		public $customizer_keys = [
			'style'            => 'wfacp_style',
			'header'           => 'wfacp_header',
			'footer'           => 'wfacp_footer',
			'gbadge'           => 'wfacp_gbadge',
			'product_switcher' => 'wfacp_form_product_switcher',

		];
		public $wfacp_html_fields = [
			'wfacp_html_widget_1' => 'Custom HTML Sidebar-1',
			'wfacp_html_widget_2' => 'Custom HTML Sidebar-2',
			'wfacp_html_widget_3' => 'Custom HTML Below Form',
		];

		protected function __construct() {
			parent::__construct();
			$this->url = WFACP_PLUGIN_URL . '/builder/customizer/templates/' . $this->get_template_slug() . '/views/';
			add_action( 'wfacp_header_print_in_head', [ $this, 'add_style_inline' ] );
			add_action( 'wfacp_header_print_in_head', [ $this, 'typography_custom_css' ] );

			add_action( 'wfacp_after_checkout_page_found', [ $this, 'setup_sidebar_data' ], 100 );

			add_action( 'wfacp_before_form', [ $this, 'add_label_position_div' ], 99 );
			add_action( 'wfacp_after_form', [ $this, 'close_label_position_div' ], 100 );

			add_filter( 'wfacp_body_class', [ $this, 'add_custom_cls' ] );
			add_filter( 'wfacp_layout_default_setting', [ $this, 'change_default_setting' ], 10, 2 );
			add_filter( 'wfacp_layout_default_setting', [ $this, 'order_btn_sticky' ], 10, 2 );
			add_filter( 'wfacp_style_default_setting', [ $this, 'multi_tab_default_setting' ], 11, 2 );
			add_filter( 'wfacp_customizer_layout', [ $this, 'customizer_layout_order' ], 11, 2 );
			add_action( 'woocommerce_before_checkout_form', [ $this, 'add_form_steps' ], 11, 2 );

			add_action( 'customize_controls_print_footer_scripts', [ $this, 'form_pop_up_content' ] );

			add_action( 'wfacp_template_after_step', [ $this, 'display_next_button' ], 11, 2 );


			add_filter( 'wfacp_layout_default_setting', [ $this, 'change_setting_for_default_checkout' ], 99, 2 );

			add_action( 'wfacp_internal_css', [ $this, 'get_embed_localize_data' ], 9 );
			add_action( 'wp_footer', [ $this, 'print_empty_style_tag' ] );
			add_filter( 'wfacp_disabled_pre_built_header_footer', [ $this, 'remove_built_in_title_tag' ] );
			add_filter( 'wfacp_cart_show_product_thumbnail', [ $this, 'display_image_in_collapsible_order_summary' ], 10, 2 );

		}

		public function enqueue_script() {
			parent::enqueue_script();

			if ( WFACP_Common::is_customizer() ) {
				$template_fields = $this->get_customizer_fields();
				wp_enqueue_script( 'underscore' );
				wp_enqueue_script( 'wp-util' );
				wp_enqueue_script( 'customizer' );
				wp_enqueue_script( 'customize-base' );
				wp_enqueue_script( 'customize-preview' );
				wp_enqueue_script( 'wfacp_customizer_live', plugin_dir_url( WFACP_PLUGIN_FILE ) . 'assets/js/customizer.js', [], WFACP_VERSION_DEV, true );
				wp_localize_script( 'wfacp_customizer_live', 'wfacp_customizer', array(
					'is_loaded' => 'yes',
					'wfacp_id'  => WFACP_Common::get_id(),
					'fields'    => $template_fields,
					'pd'        => [],
				) );
				wp_enqueue_script( 'customize-selective-refresh' );
			}
		}

		protected function get_localize_data() {
			$parent                  = parent::get_localize_data(); // TODO: Change the autogenerated stub
			$parent['is_customizer'] = WFACP_Common::is_customizer();

			return $parent;
		}


		public function customizer_data() {
			return $this->customizer_data;
		}

		public function control_filter( $control ) {
			if ( in_array( $control->section, $this->get_sections() ) ) {
				return true;
			}

			return false;
		}

		public function get_customizer_fields() {
			return $this->customizer_fields;
		}

		public function add_style_inline() {

			$deskotp_css_style = '';
			$tablet_css_style  = '';
			$mobile_css_style  = '';

			$template_type = $this->get_template_type();

			if ( isset( $this->selected_font_family ) && '' != $this->selected_font_family ) {

				$style_url = 'https://fonts.googleapis.com/css?family=' . urlencode( $this->selected_font_family );

				if ( $value = apply_filters( 'wfacp_enable_font_family', true, $template_type ) ) {
					echo "<link href='" . $style_url . "' rel=stylesheet>";
					$fonts_arr = [ 'body', 'p', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', '.select2-results__options', '#wfacp_qr_model_wrap *', '.select2-search--dropdown .select2-search__field' ];
					foreach ( $fonts_arr as $font_key => $font_value ) {
						if ( $font_value == '' ) {
							continue;
						}
						$this->customizer_css['desktop'][ $font_value ]['font-family'] = $this->selected_font_family;
					}

				}
			}


			if ( isset( $this->mini_cart_selected_font_family ) && '' != $this->mini_cart_selected_font_family ) {

				$style_url = 'https://fonts.googleapis.com/css?family=' . urlencode( $this->mini_cart_selected_font_family );

				if ( $value = apply_filters( 'wfacp_enable_mini_cart_font_family', true, $template_type ) ) {

					echo "<link href='" . $style_url . "' rel=stylesheet>";
					$fonts_arr = [
						'.wfacp_form_cart *',
						'.wfacp_form_cart .wfacp-order-summary-label',
						'.wfacp_form_cart p',
						'.wfacp_form_cart span',
						'.wfacp_form_cart h1',
						'.wfacp_form_cart h2',
						'.wfacp_form_cart h3',
						'.wfacp_form_cart h4',
						'.wfacp_form_cart h5',
						'.wfacp_form_cart h6',

					];
					foreach ( $fonts_arr as $font_key => $font_value ) {
						if ( $font_value == '' ) {
							continue;
						}


						$this->customizer_css['desktop'][ $font_value ]['font-family'] = $this->mini_cart_selected_font_family;
					}

				}
			}


			if ( $template_type == 'embed_form' ) {
				return;
			}


			$pixel_used_property = [ 'font-size', 'border-width' ];

			if ( isset( $this->customizer_css['desktop'] ) && is_array( $this->customizer_css['desktop'] ) && count( $this->customizer_css['desktop'] ) > 0 ) {


				foreach ( $this->customizer_css['desktop'] as $key => $value ) {

					foreach ( $value as $css_property => $css_value ) {
						if ( '' == $css_value ) {
							continue;
						}
						$suffix = '';
						if ( in_array( $css_property, $pixel_used_property ) && false == strpos( $css_value, 'px' ) ) {
							$suffix = 'px';
						}
						if ( 'px' == $css_value ) {
							$css_value = '0px';
							$suffix    = '';
						}

						if ( $css_property == 'content' ) {
							if ( strpos( $css_value, "&#039;" ) !== false ) {
								$selector = $css_property . ':"' . str_replace( "&#039;", "'", $css_value ) . '"';
							} else {
								$selector = $css_property . ':"' . $css_value . '"';
							}

						} else {
							$selector = $css_property . ':' . $css_value . $suffix;
						}
						$style_inline = $key . '{' . $selector . ';}' . "\n";


						$deskotp_css_style .= $style_inline;


					}
				}
			}


			if ( isset( $this->customizer_css['tablet'] ) && is_array( $this->customizer_css['tablet'] ) && count( $this->customizer_css['tablet'] ) > 0 ) {
				$tablet_css_style .= '@media (max-width: 991px) {';
				foreach ( $this->customizer_css['tablet'] as $key => $value ) {
					foreach ( $value as $css_property => $css_value ) {
						if ( '' == $css_value ) {
							continue;
						}
						$suffix = '';
						if ( in_array( $css_property, $pixel_used_property ) && false == strpos( $css_value, 'px' ) ) {
							$suffix = 'px';
						}
						if ( 'px' == $css_value ) {
							$css_value = '0px';
							$suffix    = '';
						}
						$selector         = $css_property . ':' . $css_value . $suffix;
						$style_inline     = $key . '{' . $selector . ';}';
						$tablet_css_style .= $style_inline;
					}
				}
				$tablet_css_style .= '}';
			}
			if ( isset( $this->customizer_css['mobile'] ) && is_array( $this->customizer_css['mobile'] ) && count( $this->customizer_css['mobile'] ) > 0 ) {
				$mobile_css_style .= '@media (max-width: 767px) {';
				foreach ( $this->customizer_css['mobile'] as $key => $value ) {
					foreach ( $value as $css_property => $css_value ) {
						if ( '' == $css_value ) {
							continue;
						}
						$suffix = '';
						if ( in_array( $css_property, $pixel_used_property ) && false == strpos( $css_value, 'px' ) ) {
							$suffix = 'px';
						}
						if ( 'px' == $css_value ) {
							$css_value = '0px';
							$suffix    = '';
						}
						$selector         = $css_property . ':' . $css_value . $suffix;
						$style_inline     = $key . '{' . $selector . ';}';
						$mobile_css_style .= $style_inline;
					}
				}
				$mobile_css_style .= '}';
			}


			echo '<style>';

			echo $deskotp_css_style;
			echo $tablet_css_style;
			echo $mobile_css_style;
			echo '</style>';


		}


		public function typography_custom_css() {


			$selected_template_slug = $this->get_template_slug();
			$style_custom_css       = WFACP_Common::get_option( 'wfacp_custom_css_section_' . $selected_template_slug . '_code' );

			$custom_css = '<style>' . $style_custom_css . '</style>';
			if ( isset( $style_custom_css ) && $style_custom_css != '' ) {
				echo $custom_css;
			}

		}

		public function mobile_layout_order() {
			return $this->mobile_layout_order;
		}

		public function get_setup_sidebar_data() {

			return $this->sidebar_layout_order;
		}

		public function setup_sidebar_data() {

			$selected_template_slug = $this->get_template_slug();
			$all_section_data       = WFACP_Common::get_option( 'wfacp_layout_section_customizer_data' );
			//WFACP_Common::pr( $all_section_data );

			if ( is_array( $all_section_data ) && count( $all_section_data ) > 0 ) {
				$this->sidebar_layout_order = $all_section_data;
			}


			$mobile_layout_order = WFACP_Common::get_option( 'wfacp_layout_section_' . $selected_template_slug . '_mobile_sections_page_order' );

			if ( is_array( $mobile_layout_order ) && count( $mobile_layout_order ) > 0 ) {
				$mobile_layout_order_final = $mobile_layout_order;
				if ( ! in_array( 'wfacp_form', $mobile_layout_order ) ) {
					$form_arr                  = [ 'wfacp_form' ];
					$mobile_layout_order_final = array_merge( $form_arr, $mobile_layout_order );
				}
				if ( is_array( $mobile_layout_order_final ) && count( $mobile_layout_order_final ) > 0 ) {
					$this->mobile_layout_order = $mobile_layout_order_final;
				}
			}


			$this->assign_field_data();

		}


		public function assign_field_data() {
			$detect                 = WFACP_Mobile_Detect::get_instance();
			$selected_template_slug = $this->get_template_slug();
			$selected_template_type = $this->get_template_type();


			$layout_key = '';
			if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
				$layout_key = $selected_template_slug . '_';
			}

			$this->get_wfacp_version();

			if ( $selected_template_type == 'embed_form' ) {
				$this->sidebar_layout_order[] = 'wfacp_form';
				$this->sidebar_layout_order[] = 'wfacp_style';
				$this->sidebar_layout_order[] = 'wfacp_form_product_switcher';
				$this->sidebar_layout_order[] = 'wfacp_form_cart';
			} elseif ( $selected_template_slug == 'layout_9' ) {
				$this->sidebar_layout_order[] = 'wfacp_form_cart';
			}
			if ( $detect->isMobile() && ! $detect->istablet() ) {
				$this->device_type = 'mobile';
			}
			if ( $detect->istablet() ) {
				$this->device_mb_tab = 'tablet';
			}
			$customizer_support = apply_filters( 'wfacp_customizer_supports', $this->available_fields );
			foreach ( $this->customizer_keys as $ckey => $cvalue ) {
				if ( in_array( $ckey, $customizer_support ) ) {
					$this->sidebar_layout_order[] = $cvalue;
				}
			}

			if ( empty( $this->sidebar_layout_order ) ) {
				return false;
			}


			foreach ( $this->sidebar_layout_order as $s_key => $_value ) {
				$section_key = $_value;
				if ( strpos( $section_key, 'wfacp_benefits_' ) !== false ) {

					/*  Section Heading */
					$data                    = array();
					$data['heading_section'] = $this->get_heading_section( $section_key, $selected_template_slug );


					/*  Icon Text */
					$benefits_boxes                                       = array();
					$benefits_boxes                                       = WFACP_Common::get_option( $section_key . '_section_icon_text' );
					$data['benefit_content']['icon_text']                 = $benefits_boxes;
					$data['benefit_content']['list_icon']                 = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'list_icon' );
					$data['benefit_content']['hide_list_icon']            = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'hide_list_icon' );
					$data['benefit_content']['icon_color']                = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'icon_color' );
					$data['benefit_content']['display_list_heading']      = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'display_list_heading' );
					$data['benefit_content']['show_list_description']     = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'show_list_description' );
					$data['benefit_content']['display_list_bold_heading'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'display_list_bold_heading' );

					/* Advanced Setting */

					$data['advance_setting'] = $this->get_advance_setting( $section_key, $selected_template_slug );

					/* Color Setting */
					$data['colors']                               = $this->get_color_setting( $section_key, $selected_template_slug );
					$this->customizer_fields_data[ $section_key ] = $data;
					$this->prepare_dynamic_style( $data, $section_key );

					/* Section Style */

					if ( isset( $data['colors']['heading_text_color'] ) ) {
						$heading_text_color                                                        = $data['colors']['heading_text_color'];
						$this->customizer_css['desktop'][ '.' . $section_key . ' .loop_head_sec' ] = array(
							'color' => $heading_text_color,
						);
					}

					if ( isset( $data['benefit_content']['icon_color'] ) ) {
						$this->customizer_css['desktop'][ '.' . $section_key . ' .wfacp-icon-list' ] = array(
							'color' => $data['benefit_content']['icon_color'],
						);
					}
				} elseif ( strpos( $section_key, 'wfacp_testimonials_' ) !== false ) {

					$data = array();

					/*  Section Heading */

					$data['heading_section'] = $this->get_heading_section( $section_key, $selected_template_slug );

					/* Testimonial text */
					$testimonial_data                = array();
					$testimonial_data['layout_type'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'layout_type' );

					$testimonial_data['type']             = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'testimonial_type' );
					$testimonial_data['show_review']      = WFACP_Common::get_option( $section_key . '_section_show_review' );
					$testimonial_data['review_limit']     = WFACP_Common::get_option( $section_key . '_section_review_limit' );
					$testimonial_data['hide_name']        = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'hide_name' );
					$testimonial_data['hide_designation'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'hide_designation' );
					$testimonial_data['hide_image']       = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'hide_image' );
					$testimonial_data['hide_author_meta'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'hide_author_meta' );
					$testimonial_data['image_type']       = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'image_type' );

					if ( isset( $testimonial_data['type'] ) && $testimonial_data['type'] == 'automatic' ) {
						$page_products_reviews = WFACP_Core()->public->get_product_list();

						$pr_reviews = [];


						$is_global_checkout = WFACP_Core()->public->is_checkout_override();
						if ( $is_global_checkout === true ) {
							foreach ( WC()->cart->get_cart() as $cart_item ) {
								$pr_reviews[] = $cart_item['product_id'];
							}

						} else {

							if ( is_array( $page_products_reviews ) && count( $page_products_reviews ) > 0 ) {
								foreach ( $page_products_reviews as $pr_key => $pr_val ) {
									$pr_reviews[] = $pr_val['id'];
								}
							}
						}


						if ( is_array( $pr_reviews ) && count( $pr_reviews ) > 0 ) {


							$args = array(
								'post__in'   => $pr_reviews,
								'status'     => 'approve',
								'type'       => 'all',
								'number'     => $testimonial_data['review_limit'],
								'meta_query' => array(
									array(
										'key'     => 'rating',
										'value'   => $testimonial_data['show_review'],
										'compare' => '>=',
									),
								),
								'meta_key'   => 'rating',
								'orderby'    => 'meta_value_num',
								'order'      => 'DESC',
							);

							$comments = get_comments( $args );


							if ( is_array( $comments ) && count( $comments ) > 0 ) {
								$h = 1;
								foreach ( $comments as $comment ) {
									if ( ! empty( $comment->comment_content ) ) {
										$testimonial_boxes[ $comment->comment_ID ]['tmessage'] = $comment->comment_content;
									}
									if ( ! empty( $comment->comment_author ) ) {
										$testimonial_boxes[ $comment->comment_ID ]['tname'] = $comment->comment_author;
									}
									$testimonial_boxes[ $comment->comment_ID ]['tdate']   = $comment->comment_date;
									$testimonial_boxes[ $comment->comment_ID ]['trating'] = get_comment_meta( $comment->comment_ID, 'rating', true );
									$testimonial_boxes[ $comment->comment_ID ]['timage']  = $comment->comment_author_email ? get_avatar_url( $comment->comment_author_email, array(
										'size' => 96,
									) ) : '';

									$h ++;
								}
								$testimonial_data['testimonials'] = $testimonial_boxes;
							}
						}
					} else {

						$testimonial_data['testimonials'] = WFACP_Common::get_option( $section_key . '_section_testimonials' );
					}

					$data['testimonial_data'] = $testimonial_data;
					$data['advance_setting']  = $this->get_advance_setting( $section_key, $selected_template_slug );
					$data['colors']           = $this->get_color_setting( $section_key, $selected_template_slug );

					$this->customizer_fields_data[ $section_key ] = $data;

					$this->prepare_dynamic_style( $data, $section_key );

					/* Section Style */

					if ( isset( $data['colors']['heading_text_color'] ) ) {
						$heading_text_color                                                        = $data['colors']['heading_text_color'];
						$this->customizer_css['desktop'][ '.' . $section_key . ' .loop_head_sec' ] = array(
							'color' => $heading_text_color,
						);
					}

					if ( isset( $data['colors']['content_text_color'] ) ) {
						$content_text_color                                                                    = $data['colors']['content_text_color'];
						$this->customizer_css['desktop'][ '.' . $section_key . ' .wfacp-testi-content-color' ] = array(
							'color' => $content_text_color,
						);
					}
				} elseif ( strpos( $section_key, 'wfacp_promises_' ) !== false ) {
					$data = array();

					/* Promises Contents */

					$text_alignment                        = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'text_alignment' );
					$hide_text                             = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'hide_text' );
					$show_divider                          = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'show_divider' );
					$divider_color                         = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'divider_color' );
					$select_badge_structure                = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'select_badge_structure' );
					$promises_data['icon_text']            = WFACP_Common::get_option( $section_key . '_section_promise_icon_text' );
					$promises_data['show_promise_section'] = WFACP_Common::get_option( $section_key . '_section_show_promise_section' );

					$promises_data['text_alignment']         = $text_alignment;
					$promises_data['hide_text']              = $hide_text;
					$promises_data['show_divider']           = $show_divider;
					$promises_data['divider_color']          = $divider_color;
					$promises_data['select_badge_structure'] = $select_badge_structure;

					/* Advanced Setting */
					$data['advance_setting'] = $this->get_advance_setting( $section_key, $selected_template_slug );

					/* Color Setting */
					$data['colors']                               = $this->get_color_setting( $section_key, $selected_template_slug );
					$data['promises_data']                        = $promises_data;
					$this->customizer_fields_data[ $section_key ] = $data;

					$this->prepare_dynamic_style( $data, $section_key );
					$align_position = 'center';

					if ( $text_alignment == 'wfacp-text-left' ) {
						$align_position = 'left';
					} elseif ( $text_alignment == 'wfacp-text-right' ) {
						$align_position = 'right';
					}

					if ( isset( $this->customizer_css['desktop'][ '.' . $section_key . ' p ' ] ) ) {
						$p_content                                                     = $this->customizer_css['desktop'][ '.' . $section_key . ' p ' ];
						$p_content['text-align']                                       = $align_position;
						$this->customizer_css['desktop'][ '.' . $section_key . ' p ' ] = $p_content;
					}

					/* Section Style */

					if ( isset( $promises_data['divider_color'] ) ) {
						$show_divider                                                                                            = $promises_data['divider_color'];
						$this->customizer_css['desktop'][ '.' . $section_key . ' .wfacp-permission-icon ul li' ]['border-color'] = $show_divider;
					}
				} elseif ( strpos( $section_key, 'wfacp_assurance_' ) !== false ) {

					$data           = [];
					$assurance_data = [];

					$data['heading_section'] = $this->get_heading_section( $section_key, $selected_template_slug );

					/* Assurance Data  */
					$hide_title         = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'hide_title' );
					$enable_divider     = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'enable_divider' );
					$divider_color      = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'divider_color' );
					$mwidget_show_image = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'mwidget_show_image' );

					$assurance_data['hide_title']     = $hide_title;
					$assurance_data['enable_divider'] = $enable_divider;

					$assurance_data['list']                          = WFACP_Common::get_option( $section_key . '_section_mwidget_listw' );
					$data['assurance_data']                          = $assurance_data;
					$data['assurance_data']['section_mwidget_listw'] = $mwidget_show_image;

					/* Advanced Setting */
					$data['advance_setting']                      = $this->get_advance_setting( $section_key, $selected_template_slug );
					$this->customizer_fields_data[ $section_key ] = $data;

					/* Color Setting */
					$data['colors']                  = $this->get_color_setting( $section_key, $selected_template_slug );
					$data['colors']['divider_color'] = $divider_color;

					$this->customizer_fields_data[ $section_key ] = $data;

					$this->prepare_dynamic_style( $data, $section_key );

					if ( isset( $data['colors']['heading_text_color'] ) ) {
						$this->customizer_css['desktop'][ '.' . $section_key . ' h2' ] = array(
							'color' => $data['colors']['heading_text_color'],
						);
					}

					if ( isset( $data['colors']['divider_color'] ) ) {
						$this->customizer_css['desktop'][ '.' . $section_key . ' .wfacp-information-container .wfacp_enable_border' ]['border-color'] = $divider_color;
					}
				} elseif ( strpos( $section_key, 'wfacp_customer_' ) !== false ) {
					/*  Section Heading */
					$data                    = [];
					$data['heading_section'] = $this->get_heading_section( $section_key, $selected_template_slug );

					/*  Section Customer Support Data */
					$customer_support                              = array();
					$customer_support['supporter_name']            = WFACP_Common::get_option( $section_key . '_section_supporter_name' );
					$customer_support['supporter_image']           = WFACP_Common::get_option( $section_key . '_section_supporter_image' );
					$customer_support['supporter_designation']     = WFACP_Common::get_option( $section_key . '_section_supporter_designation' );
					$customer_support['supporter_signature_image'] = WFACP_Common::get_option( $section_key . '_section_supporter_signature_image' );
					$customer_support['contact_heading']           = WFACP_Common::get_option( $section_key . '_section_contact_heading' );
					$customer_support['contact_description']       = WFACP_Common::get_option( $section_key . '_section_contact_description' );
					$customer_support['contact_chat']              = WFACP_Common::get_option( $section_key . '_section_contact_chat' );
					$customer_support['contact_timing']            = WFACP_Common::get_option( $section_key . '_section_contact_timing' );
					$data['customer_support']                      = $customer_support;

					/* Sub heading section */
					$data['sub_heading_section'] = $this->get_sub_heading_section( $section_key, $selected_template_slug );

					/* Advanced Setting */
					$data['advance_setting'] = $this->get_advance_setting( $section_key, $selected_template_slug );

					$this->customizer_fields_data[ $section_key ] = $data;

					$this->prepare_dynamic_style( $data, $section_key );

					/* Color Setting */
					$data_keys = $this->get_section_keys_data( $section_key );
					if ( is_array( $data_keys ) && count( $data_keys ) ) {
						$color_meta = [
							'panel'    => $section_key,
							'section'  => 'section',
							'template' => $selected_template_slug,
							'key'      => 'colors',
						];
						$this->assign_colors( $data_keys, $color_meta );
					}

					$this->wfacp_font_size( $data['sub_heading_section'], array(
						'section_key' => $section_key,
						'target_to'   => '.' . $section_key . ' .wfacp-subtitle',
						'source_from' => 'heading_fs',
					) );
				} elseif ( $section_key == 'wfacp_header' ) {
					$data = array();


					if ( 'layout_9' == $selected_template_slug ) {
						$data['header_layout'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'header_layout' );
						$this->set_temaplete_header_layout( $data['header_layout'] );

					}

					/* Advanced Setting */
					$data['advance_setting'] = $this->get_advance_setting( $section_key, $selected_template_slug );

					//$data['colors'] = $this->get_color_setting( $section_key, $selected_template_slug );

					/* Header data  */
					$data['header_data']['logo']                 = WFACP_Common::get_option( $section_key . '_section_logo' );
					$data['header_data']['logo_link']            = WFACP_Common::get_option( $section_key . '_section_logo_link' );
					$data['header_data']['logo_link_target']     = WFACP_Common::get_option( $section_key . '_section_logo_link_target' );
					$data['header_data']['logo_width']           = WFACP_Common::get_option( $section_key . '_section_logo_width' );
					$data['header_data']['page_meta_title']      = WFACP_Common::get_option( $section_key . '_section_page_meta_title' );
					$data['header_data']['header_text']          = WFACP_Common::get_option( $section_key . '_section_header_text' );
					$data['header_data']['email']                = WFACP_Common::get_option( $section_key . '_section_email' );
					$data['header_data']['phone']                = WFACP_Common::get_option( $section_key . '_section_phone' );
					$data['header_data']['tel_number']           = WFACP_Common::get_option( $section_key . '_section_tel_number' );
					$data['header_data']['helpdesk_url']         = WFACP_Common::get_option( $section_key . '_section_helpdesk_url' );
					$data['header_data']['helpdesk_text']        = WFACP_Common::get_option( $section_key . '_section_helpdesk_text' );
					$data['header_data']['helpdesk_link_target'] = WFACP_Common::get_option( $section_key . '_section_helpdesk_link_target' );

					if ( isset( $data['header_layout'] ) && $data['header_layout'] == 'outside_header' ) {

						$data['colors']['section_bg_color']   = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'outside_section_bg_color' );
						$data['colors']['header_icon_color']  = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'outside_header_icon_color' );
						$data['colors']['content_text_color'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'outside_content_text_color' );

					} else {
						$data['colors']['section_bg_color']   = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'section_bg_color' );
						$data['colors']['header_icon_color']  = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'header_icon_color' );
						$data['colors']['content_text_color'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'content_text_color' );

					}

					$header_icon_color  = $data['colors']['header_icon_color'];
					$content_text_color = $data['colors']['content_text_color'];

					if ( isset( $header_icon_color ) ) {

						$this->customizer_css['desktop']['.wfacp_header span.wfacp-hd-list-help:before']['color']  = $header_icon_color;
						$this->customizer_css['desktop']['.wfacp_header span.wfacp-hd-list-email:before']['color'] = $header_icon_color;
						$this->customizer_css['desktop']['.wfacp_header span.wfacp-hd-list-phn:before']['color']   = $header_icon_color;

					}

					if ( isset( $content_text_color ) ) {

						$this->customizer_css['desktop']['.wfacp_header .wfacp-header-nav ul li']['color']   = $content_text_color;
						$this->customizer_css['desktop']['.wfacp_header .wfacp-header-nav ul li a']['color'] = $content_text_color;
					}

					if ( isset( $data['header_data']['logo_width'] ) ) {
						$this->customizer_css['desktop']['.wfacp_header .wfacp-logo'] = array(
							'max-width' => $data['header_data']['logo_width'] . 'px',
						);

					}

					/* Prepare Dynamic Style */
					$this->prepare_dynamic_style( $data, $section_key );

					/* Assign Data to customizer fields */
					$this->customizer_fields_data[ $section_key ] = $data;

				} elseif ( $section_key == 'wfacp_footer' ) {

					$data = [];

					/* Footer Data */

					$data['footer_data']['ft_ct_content'] = WFACP_Common::get_option( $section_key . '_section_ft_text' );
					$data['footer_data']['ft_text_fs']    = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'ft_text_fs' );

					/* colors Setting */
					$data['colors'] = $this->get_color_setting( $section_key, $selected_template_slug );

					if ( isset( $data['colors']['content_text_color'] ) ) {
						$content_text_color                                            = $data['colors']['content_text_color'];
						$this->customizer_css['desktop'][ '.' . $section_key . ' p' ]  = array(
							'color' => $content_text_color,
						);
						$this->customizer_css['desktop'][ '.' . $section_key . ' li' ] = array(
							'color' => $content_text_color,
						);
						$this->customizer_css['desktop'][ '.' . $section_key . ' a' ]  = array(
							'color' => $content_text_color,
						);
						$this->customizer_css['desktop'][ '.' . $section_key ]         = array(
							'color' => $content_text_color,
						);
					}

					/* Prepare Dynamic Style */
					$this->prepare_dynamic_style( $data, $section_key );

					/* Assign Data to customizer fields */
					$this->customizer_fields_data[ $section_key ] = $data;

					$this->wfacp_font_size( $data['footer_data'], array(
						'section_key' => 'wfacp_footer',
						'target_to'   => '.' . $section_key . ' .wfacp-footer-text',
						'source_from' => 'ft_text_fs',
					) );
					$this->wfacp_font_size( $data['footer_data'], array(
						'section_key' => 'wfacp_footer',
						'target_to'   => '.' . $section_key . ' .wfacp-footer-text p',
						'source_from' => 'ft_text_fs',
					) );

				} elseif ( strpos( $section_key, 'wfacp_product' ) !== false ) {
					$data = array();

					$layout_key = '';
					if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
						$layout_key = $selected_template_slug . '_';
					}

					if ( $selected_template_slug == 'layout_9' ) {
						$data['heading_section'] = $this->get_heading_section( $section_key, $selected_template_slug );
						$data['advance_setting'] = $this->get_advance_setting( $section_key, $selected_template_slug );

						$data['product_data']['product_layouts'] = WFACP_Common::get_option( $section_key . '_section_layouts' );

					}

					$data['product_data']['layouts'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'section_height' );
					$product_section_height          = $data['product_data']['layouts'];

					$data['product_data']['enable_product_section'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'enable_product_section' );

					if ( isset( $data['product_data']['enable_product_section'] ) && $data['product_data']['enable_product_section'] == true ) {
						if ( $selected_template_slug == 'layout_1' || $selected_template_slug == 'layout_4' ) {

							$this->customizer_css['desktop'][ 'body .' . $section_key ] = array(
								'min-height' => $product_section_height . 'px',
							);
							$this->customizer_css['mobile'][ 'body .' . $section_key ]  = array(
								'min-height' => '1px',
							);
						}
					} else {

						$this->customizer_css['desktop'][ 'body .' . $section_key ] = array(
							'min-height' => '1px',
						);
						$this->customizer_css['mobile'][ 'body .' . $section_key ]  = array(
							'min-height' => '1px',
						);
					}

					$data['product_data']['section_height'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'section_height' );

					/* Product Data */

					$data['product_data']['enable_product_image'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'enable_product_image' );
					$data['product_data']['product_image']        = WFACP_Common::get_option( $section_key . '_section_product_image' );
					$data['product_data']['title']                = WFACP_Common::get_option( $section_key . '_section_title' );
					$data['product_data']['title_fs']             = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'title_fs' );

					$data['product_data']['desc']    = WFACP_Common::get_option( $section_key . '_section_desc' );
					$data['product_data']['desc_fs'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'desc_fs' );

					/* colors Setting */
					$data['colors'] = $this->get_color_setting( $section_key, $selected_template_slug );

					/* Prepare Dynamic Style */
					$this->prepare_dynamic_style( $data, $section_key );

					/* Assign Data to customizer fields */
					$this->customizer_fields_data[ $section_key ] = $data;

					if ( isset( $data['colors']['heading_text_color'] ) ) {
						$heading_text_color                                                             = $data['colors']['heading_text_color'];
						$this->customizer_css['desktop'][ '.' . $section_key . ' .wfacp_heading_text' ] = array(
							'color' => $heading_text_color,
						);
					}

					$this->wfacp_font_size( $data['product_data'], array(
						'section_key' => $section_key,
						'target_to'   => '.' . $section_key . ' .wfacp_heading_text',
						'source_from' => 'title_fs',
					) );
					$this->wfacp_font_size( $data['product_data'], array(
						'section_key' => $section_key,
						'target_to'   => '.' . $section_key . ' p',
						'source_from' => 'desc_fs',
					) );

				} elseif ( $section_key == 'wfacp_gbadge' ) {

					$layout_key = '';
					if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
						$layout_key = $selected_template_slug . '_';
					}

					$data = array();

					$data['gbadge_data']['enable_icon']       = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'enable_icon' );
					$data['gbadge_data']['badge_icon']        = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'badge_icon' );
					$data['gbadge_data']['custom_list_image'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'custom_list_image' );
					$data['gbadge_data']['badge_max_width']   = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'badge_max_width' );

					$data['gbadge_data']['badge_margin_left'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'badge_margin_left' );
					$data['gbadge_data']['badge_margin_top']  = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'badge_margin_top' );

					if ( is_array( $this->default_badges ) && count( $this->default_badges ) > 0 ) {
						if ( isset( $data['gbadge_data']['badge_icon'] ) && $data['gbadge_data']['badge_icon'] != '' ) {
							$bage_icon                             = $data['gbadge_data']['badge_icon'];
							$data['gbadge_data']['badge_icon_src'] = $this->default_badges[ $bage_icon ];
						}
					}

					$this->customizer_fields_data[ $section_key ] = $data;

					/* Prepare Dynamic Style */
					$this->prepare_dynamic_style( $data, $section_key );

					if ( isset( $data['gbadge_data']['badge_max_width'] ) ) {
						$badge_max_width                                                             = $data['gbadge_data']['badge_max_width'] . 'px';
						$this->customizer_css['desktop'][ '.' . $section_key . ' .wfacp_max_width' ] = array(
							'max-width' => $badge_max_width,
						);

					}

					if ( isset( $data['gbadge_data']['badge_margin_left'] ) ) {
						$badge_margin_left                                                             = $data['gbadge_data']['badge_margin_left'] . 'px';
						$this->customizer_css['desktop'][ '.' . $section_key . ' img' ]['margin-left'] = $badge_margin_left;
						$this->customizer_css['mobile'][ '.' . $section_key . ' img' ]['margin-left']  = 'initial';
					}

					if ( isset( $data['gbadge_data']['badge_margin_top'] ) ) {
						$badge_margin_top = $data['gbadge_data']['badge_margin_top'] . 'px';

						$this->customizer_css['desktop'][ '.' . $section_key . ' img' ]['margin-top'] = $badge_margin_top;
						$this->customizer_css['mobile'][ '.' . $section_key . ' img' ]['margin-top']  = 'initial';
					}
				} elseif ( $section_key == 'wfacp_style' ) {

					$layout_key = '';
					if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
						$layout_key = $selected_template_slug . '_';
					}
					$data = array();

					$data['wfacp_style']['body_background_color'] = WFACP_Common::get_option( $section_key . '_colors_' . $layout_key . 'body_background_color' );

					$data['wfacp_style']['sidebar_background_color'] = WFACP_Common::get_option( $section_key . '_colors_' . $layout_key . 'sidebar_background_color' );

					$data['wfacp_style']['content_fs'] = WFACP_Common::get_option( $section_key . '_typography_' . $layout_key . 'content_fs' );
					$data['wfacp_style']['content_ff'] = WFACP_Common::get_option( $section_key . '_typography_' . $layout_key . 'content_ff' );


					if ( isset( $data['wfacp_style']['content_fs']['desktop'] ) && $data['wfacp_style']['content_fs']['desktop'] != '' ) {
						$desktop_fs                                                                                                                    = $data['wfacp_style']['content_fs']['desktop'] + 4;
						$this->customizer_css['desktop']['.wfacp_main_wrapper .wc-amazon-payments-advanced-populated .create-account h3']['font-size'] = $desktop_fs . 'px';
					}

					if ( isset( $data['wfacp_style']['content_fs']['mobile'] ) && $data['wfacp_style']['content_fs']['mobile'] != '' ) {
						$mobile_fs                                                                                                                     = $data['wfacp_style']['content_fs']['mobile'] + 4;
						$this->customizer_css['desktop']['.wfacp_main_wrapper .wc-amazon-payments-advanced-populated .create-account h3']['font-size'] = $mobile_fs . 'px';
					}

					if ( isset( $data['wfacp_style']['content_ff'] ) && $data['wfacp_style']['content_ff'] != '' ) {
						$this->selected_font_family = $data['wfacp_style']['content_ff'];
					}


					$this->prepare_dynamic_style( $data, $section_key );

					if ( isset( $data['wfacp_style']['body_background_color'] ) ) {
						$this->customizer_css['desktop']['body']                  = array(
							'background' => $data['wfacp_style']['body_background_color'],
						);
						$this->customizer_css['desktop']['.wfacp-main-container'] = array(
							'background' => $data['wfacp_style']['body_background_color'],
						);

						if ( $selected_template_slug == 'layout_2' ) {
							$this->customizer_css['desktop']['body .wfacp-panel-wrapper'] ['background'] = $data['wfacp_style']['body_background_color'];

						}
					}

					if ( isset( $data['wfacp_style']['sidebar_background_color'] ) ) {

						$this->customizer_css['desktop']['.wfacp-right-panel']                                                       = array(
							'background' => $data['wfacp_style']['sidebar_background_color'],
						);
						$this->customizer_css['mobile'][ '.wfacp-mobile .' . $selected_template_slug . '_temp.wfacp-panel-wrapper' ] = array(
							'background' => $data['wfacp_style']['sidebar_background_color'],
						);
						$this->customizer_css['mobile'][ '.wfacp-mobile .' . $selected_template_slug . '_temp .wfacp-form' ]         = array(
							'margin-bottom' => '5px',
						);

						if ( $selected_template_slug == 'layout_9' ) {
							$this->customizer_css['desktop'][ 'body.wfacp_cls_' . $selected_template_slug . ' .wfacp-panel-wrapper.wfacp_outside_header:before' ]['background'] = $data['wfacp_style']['sidebar_background_color'];
							$this->customizer_css['mobile'][ 'body.wfacp_cls_' . $selected_template_slug . ' .wfacp-panel-wrapper:before' ]['display']                          = 'none';
						}
					}

					$this->wfacp_font_size( $data[ $section_key ], array(
						'section_key' => $section_key,
						'target_to'   => 'body p',
						'source_from' => 'content_fs',
					) );

					$this->wfacp_font_size( $data[ $section_key ], array(
						'section_key' => $section_key,
						'target_to'   => '.wfacp-comm-inner-inf p',
						'source_from' => 'content_fs',
					) );

					/* update layout 4 fonts */
					if ( $selected_template_slug == 'layout_4' ) {
						$this->wfacp_font_size( $data[ $section_key ], array(
							'section_key' => $section_key,
							'target_to'   => '.wfacp-list-panel p',
							'source_from' => 'content_fs',
						) );
						$this->wfacp_font_size( $data[ $section_key ], array(
							'section_key' => $section_key,
							'target_to'   => '.wfacp-testing-text p',
							'source_from' => 'content_fs',
						) );
					}

					$this->customizer_fields_data['wfacp_style'] = $data;

				} elseif ( $section_key == 'wfacp_form' ) {


					$data = array();

					$data['heading_section'] = $this->get_heading_section( $section_key, $selected_template_slug );
					$data['colors']          = $this->get_color_setting( $section_key, $selected_template_slug );

					$layout_key = '';
					if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
						$layout_key = $selected_template_slug . '_';
						if ( 'layout_9' == $selected_template_slug ) {
							$data['order_hide_img'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'order_hide_img' );
						}
					}


					if ( $selected_template_slug == 'layout_9' || strpos( $selected_template_slug, 'embed_forms' ) !== false ) {


						$data['form_data']['enable_collapsible_order_summary'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'enable_collapsible_order_summary' );
						$data['form_data']['cart_collapse_title']              = WFACP_Common::get_option( $section_key . '_section_cart_collapse_title' );
						$data['form_data']['cart_expanded_title']              = WFACP_Common::get_option( $section_key . '_section_cart_expanded_title' );
						$data['form_data']['enable_coupon']                    = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'enable_coupon' );
						$data['form_data']['enable_coupon_collapsible']        = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'enable_coupon_collapsible' );


					}

					/* heading section */
					$data['heading_section'] = $this->get_heading_section( $section_key, $selected_template_slug );

					/* Sub heading section */
					$data['sub_heading_section'] = $this->get_sub_heading_section( $section_key, $selected_template_slug );

					/* Field Style */
					$data['form_data']['field_style'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'field_style_fs' );
					if ( ! is_array( $data['form_data']['field_style'] ) ) {
						$data['form_data']['field_style'] = [];
					}

					$data['form_data']['field_style']['focus_color'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'field_focus_color' );
					$data['form_data']['text_below_placeorder_btn']  = WFACP_Common::get_option( $section_key . '_section_text_below_placeorder_btn' );

					/* product switcher */

					$data['form_data']['best_value']['best_value_product']    = WFACP_Common::get_option( $section_key . '_section_best_value_product' );
					$data['form_data']['best_value']['best_value_text']       = WFACP_Common::get_option( $section_key . '_section_best_value_text' );
					$data['form_data']['best_value']['best_value_text_color'] = WFACP_Common::get_option( $section_key . '_section_best_value_text_color' );
					$data['form_data']['best_value']['best_value_bg_color']   = WFACP_Common::get_option( $section_key . '_section_best_value_bg_color' );

					$data['form_data']['field_style_position'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'field_style_position' );

					$data['border']['form_head']['border-style']  = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'rbox_border_type' );
					$data['border']['form_head']['border-width']  = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'rbox_border_width' );
					$data['border']['form_head']['border-color']  = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'rbox_border_color' );
					$data['border']['form_head']['padding-left']  = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'rbox_padding' );
					$data['border']['form_head']['padding-right'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'rbox_padding' );
					$data['border']['form_head']['margin-bottom'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'rbox_margin' );


					$data['border']['form_field_style']['border-style'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'field_border_layout' );
					$data['border']['form_field_style']['border-width'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'field_border_width' );
					$data['border']['form_field_style']['border-color'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'field_border_color' );

					$data['form_data']['payment_methods_heading']     = WFACP_Common::get_option( $section_key . '_section_payment_methods_heading' );
					$data['form_data']['payment_methods_sub_heading'] = WFACP_Common::get_option( $section_key . '_section_payment_methods_sub_heading' );
					$data['form_data']['label_position']              = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'wfacp_label_position' );


					if ( is_array( $data['border']['form_head'] ) && count( $data['border']['form_head'] ) > 0 ) {
						foreach ( $data['border']['form_head'] as $key1 => $value1 ) {

							$unit = 'px';
							if ( $key1 == 'border-color' || $key1 == 'border-style' ) {
								$unit = '';
							}


							$this->customizer_css['desktop']['.wfacp_main_form .wfacp-comm-title'][ $key1 ] = $value1 . $unit;


						}
					}


					if ( is_array( $data['border']['form_field_style'] ) && count( $data['border']['form_field_style'] ) > 0 ) {
						foreach ( $data['border']['form_field_style'] as $key1 => $value1 ) {

							$unit = 'px';
							if ( $key1 == 'border-color' || $key1 == 'border-style' ) {
								$unit = '';
							}

							$this->customizer_css['desktop']['body .wfacp_main_form .woocommerce-input-wrapper select.wfacp-form-control'][ $key1 ]                       = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form .woocommerce-input-wrapper .wfacp-form-control'][ $key1 ]                             = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form .woocommerce-input-wrapper .wfacp-form-control-wrapper input'][ $key1 ]               = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form .woocommerce-input-wrapper .wfacp-form-control-wrapper select'][ $key1 ]              = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form select'][ $key1 ]                                                                     = $value1 . $unit;
							$this->customizer_css['desktop']['#et-boc .et-l span.select2-selection.select2-selection--multiple'][ $key1 ]                                 = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form .select2-container .select2-selection--single .select2-selection__rendered'][ $key1 ] = $value1 . $unit . " !important";
							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) select:focus'][ $key1 ]            = $value1 . $unit . " !important";


							$this->customizer_css['desktop']['body .wfacp_main_form .wfacp_allowed_countries strong'][ $key1 ] = $value1 . $unit;

							$this->customizer_css['desktop']['body .wfacp_main_form select.wfacp-form-control'][ $key1 ] = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form .wfacp-form-control'][ $key1 ]       = $value1 . $unit;

							$this->customizer_css['desktop']['body .wfacp_main_form .wc-amazon-payments-advanced-populated .create-account p.form-row input[type="text"]'][ $key1 ]     = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form .wc-amazon-payments-advanced-populated .create-account p.form-row input[type="email"]'][ $key1 ]    = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form .wc-amazon-payments-advanced-populated .create-account p.form-row input[type="password"]'][ $key1 ] = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form .wc-amazon-payments-advanced-populated .create-account p.form-row select'][ $key1 ]                 = $value1 . $unit;

							if ( $key1 !== 'border-color' ) {

								$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-email) input[type=email]:hover'][ $key1 ]                                                                   = $value1 . $unit;
								$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=password]:hover'][ $key1 ]                                                       = $value1 . $unit;
								$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=search]:hover'][ $key1 ]                                                         = $value1 . $unit;
								$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=tel]:hover'][ $key1 ]                                                            = $value1 . $unit;
								$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=text]:hover'][ $key1 ]                                                           = $value1 . $unit;
								$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=url]:hover'][ $key1 ]                                                            = $value1 . $unit;
								$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) textarea:hover'][ $key1 ]                                                                   = $value1 . $unit;
								$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) select:hover'][ $key1 ]                                                                     = $value1 . $unit;
								$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) .select2-container .select2-selection--single .select2-selection__rendered:hover'][ $key1 ] = $value1 . $unit . " !important";
							}
						}
					}

					/* Set data on global Field */
					$this->customizer_fields_data['wfacp_form'] = $data;


					/*  Color field*/
					$data_keys       = $this->get_section_keys_data( 'wfacp_form' );
					$form_color_meta = [
						'panel'    => $section_key,
						'section'  => 'section',
						'template' => $selected_template_slug,
						'key'      => 'colors',
					];
					$this->assign_colors( $data_keys, $form_color_meta );

					/* add button styling */
					$num_of_steps = $this->get_step_count();

					$bread_crumb_count = $num_of_steps + 1;

					if ( $bread_crumb_count > 1 ) {
						$steps_text = [];
						for ( $bi = 0; $bi < $bread_crumb_count; $bi ++ ) {
							$step_text_here = WFACP_Common::get_option( $section_key . '_section_breadcrumb_' . $bi . '_step_text' );

							if ( isset( $step_text_here ) && $step_text_here != '' ) {
								$steps_text[] = $step_text_here;
								unset( $step_text_here );
							}
						}

						if ( is_array( $steps_text ) && count( $steps_text ) > 0 ) {
							$this->customizer_fields_data['wfacp_form']['form_data']['breadcrumb'] = $steps_text;
						}
					}
					if ( $num_of_steps > 1 ) {

						$_enable_cart_in_breadcrumb = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . "_enable_cart_in_breadcrumb" );
						$cart_text                  = WFACP_Common::get_option( $section_key . '_section_cart_text' );

						$this->customizer_fields_data['wfacp_form']['form_data']['breadcrumb_before'] = [
							'enable_cart'      => $_enable_cart_in_breadcrumb,
							'enable_cart_text' => $cart_text,
						];

					}

					$step_btns = [ 'order-place' ];
					if ( $num_of_steps > 1 ) {
						$text        = 'next';
						$step_btns[] = $text;

					}
					$btn_arr = [];

					for ( $i = 0; $i < $num_of_steps; $i ++ ) {

						$enable_icon_before_button = WFACP_Common::get_option( 'wfacp_form_section_step_' . $i . '_enable_icon_before_button' );
						$icon_before_button        = WFACP_Common::get_option( 'wfacp_form_section_step_' . $i . '_icon_before_button' );
						$text_after_button         = WFACP_Common::get_option( 'wfacp_form_section_step_' . $i . '_text_after_button' );


						if ( $i == 0 ) {
							$step_key = 'single_step';
						} elseif ( $i == 1 ) {
							$step_key = 'two_step';
						} elseif ( $i > 1 ) {
							$step_key = 'third_step';
						}

						if ( 'yes' === $enable_icon_before_button && ! empty( $icon_before_button ) ) {


							if ( strpos( str_replace( 'aero-', '', $icon_before_button ), '"\"' ) == false ) {
								$icon_before_button = '"\"' . $icon_before_button;
								$icon_before_button = str_replace( '"', '', $icon_before_button );

							}


							$this->customizer_css['desktop'][ 'body .wfacp_main_form #wfacp_checkout_form  .' . $step_key . " .button:before" ] = [
								'content'        => str_replace( 'aero-', '', $icon_before_button ),
								'font-family'    => 'bwf-icons !important',
								'display'        => 'inline-block !important',
								'margin-right'   => '8px',
								'position'       => 'relative',
								'text-transform' => 'none',
								'top'            => '0',
							];
						}


						if ( ! empty( $text_after_button ) ) {
							$this->customizer_css['desktop'][ 'body .wfacp_main_form #wfacp_checkout_form  .' . $step_key . " .button:after" ] = [
								'content' => $text_after_button,

								'position' => 'relative',
								'display'  => 'block',
							];
						}


					}


					foreach ( $step_btns as $skey => $svalue ) {
						$st_id          = '';
						$text_after_btn = '';

						$btn_text[ $svalue ] = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_btn_text' );


						if ( isset( $btn_text['next'] ) && $btn_text['next'] != '' ) {
							$btn_text['back'] = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_back_btn_text' );

						}

						$btn_class_key        = 'button';
						$btn_parent_class_key = 'wfacp-' . $svalue . '-btn-wrap';
						if ( $svalue == 'order-place' ) {
							$st_id = '#place_order';
						} elseif ( $svalue == 'next' ) {
							$svalue = 'order-place';
						}

						$btn_wrap_class = '.wfacp_main_form .' . $btn_parent_class_key;

						$btn_class = 'body .wfacp_main_form .woocommerce-checkout .button.' . $btn_class_key . $st_id;


						$width                        = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_width' );
						$btn_talign                   = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_talign' );
						$btn_font_weight              = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_btn_font_weight' );
						$make_button_sticky_on_mobile = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_make_button_sticky_on_mobile' );
						$btn_fs                       = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_fs' );
						$btn_top_bottom_padding       = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_top_bottom_padding' );
						$left_right_padding           = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_left_right_padding' );
						$border_radius                = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_border_radius' );


						$btn_arr = [
							'btn_text'                     => $btn_text,
							'width'                        => $width,
							'talign'                       => $btn_talign,
							'btn_font_weight'              => $btn_font_weight,
							'make_button_sticky_on_mobile' => $make_button_sticky_on_mobile,
							'fs'                           => $btn_fs,
							'top_bottom_padding'           => $btn_top_bottom_padding,
							'left_right_padding'           => $left_right_padding,
							'border_radius'                => $border_radius,

						];


						$this->customizer_css['desktop'][ 'body .wfacp_main_form .woocommerce-checkout .' . $btn_parent_class_key ]['text-align'] = $btn_talign;

						$this->customizer_css['desktop'][ $btn_class ]['padding-top']    = $btn_top_bottom_padding . 'px';
						$this->customizer_css['desktop'][ $btn_class ]['padding-bottom'] = $btn_top_bottom_padding . 'px';
						$this->customizer_css['desktop'][ $btn_class ]['font-weight']    = $btn_font_weight;

						$this->customizer_css['desktop'][ $btn_class ]['padding-left']  = $left_right_padding . 'px';
						$this->customizer_css['desktop'][ $btn_class ]['padding-right'] = $left_right_padding . 'px';
						$this->customizer_css['desktop'][ $btn_class ]['border-radius'] = $border_radius . 'px';

						$this->customizer_css['desktop'][ $btn_class ]['width'] = $width;


						if ( isset( $data['form_data']['field_style']['focus_color'] ) ) {
							$field_focus_color = $data['form_data']['field_style']['focus_color'];


							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=password]:focus']['box-shadow'] = "0 0 0 1px $field_focus_color";
							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=search]:focus']['box-shadow']   = "0 0 0 1px $field_focus_color";
							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=tel]:focus']['box-shadow']      = "0 0 0 1px $field_focus_color";
							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=number]:focus']['box-shadow']   = "0 0 0 1px $field_focus_color";

							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=url]:focus']['box-shadow'] = "0 0 0 1px $field_focus_color";
							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) textarea:focus']['box-shadow']        = "0 0 0 1px $field_focus_color";

							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) select:focus']['box-shadow']                                                                     = "0 0 0 1px $field_focus_color";
							$this->customizer_css['desktop']['body .wfacp-right-panel #coupon_code:focus']['box-shadow']                                                                                                                = "0 0 0 1px $field_focus_color !important";
							$this->customizer_css['desktop']['form.checkout_coupon.woocommerce-form-coupon .wfacp-col-left-half input:focus']['border-color']                                                                           = "$field_focus_color !important;";
							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) .woocommerce-input-wrapper .select2-container .select2-selection--single:focus']['border-color'] = "$field_focus_color !important;";

							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) .woocommerce-input-wrapper .select2-container .select2-selection--single:focus > span.select2-selection__rendered']['border-color'] = "$field_focus_color !important;";
							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) .woocommerce-input-wrapper .select2-container .select2-selection--single:focus']['box-shadow']                                      = "0 0 0 1px $field_focus_color !important";


						}

						if ( $width == 'initial' ) {
							$this->customizer_css['desktop']["_:-ms-fullscreen, :root body .wfacp_main_form .woocommerce-checkout .button.button"]['width'] = "auto !important";
						}


						if ( isset( $data['heading_section']['heading_fs'] ) ) {

							$subscription_target = 'body .wfacp_main_form .ia_subscription_items h3';

							$this->wfacp_font_size( $data['heading_section'], array(
								'section_key' => $section_key,
								'target_to'   => $subscription_target,
								'source_from' => 'heading_fs',
							) );

							if ( isset( $data['heading_section']['heading_talign'] ) ) {
								if ( $data['heading_section']['heading_talign'] == 'wfacp-text-left' ) {
									$align_pos = 'left';
								} elseif ( $data['heading_section']['heading_talign'] == 'wfacp-text-right' ) {
									$align_pos = 'right';
								} else {
									$align_pos = 'center';
								}
							}

							if ( isset( $data['heading_section']['heading_font_weight'] ) ) {
								if ( $data['heading_section']['heading_font_weight'] == 'wfacp-normal' ) {
									$font_weight_subs = 'normal';
								} else {
									$font_weight_subs = 'bold';
								}
							}

							$this->customizer_css['desktop'][ $subscription_target ]['text-align']  = $align_pos;
							$this->customizer_css['desktop'][ $subscription_target ]['font-weight'] = $font_weight_subs;

						}

						if ( isset( $data['heading_section']['heading_fs'] ) ) {

							$subscription_target = 'body .wfacp_main_form #woocommerce_eu_vat_compliance #woocommerce_eu_vat_compliance_vat_number h3';

							$this->wfacp_font_size( $data['heading_section'], array(
								'section_key' => $section_key,
								'target_to'   => $subscription_target,
								'source_from' => 'heading_fs',
							) );

							if ( isset( $data['heading_section']['heading_talign'] ) ) {
								if ( $data['heading_section']['heading_talign'] == 'wfacp-text-left' ) {
									$align_pos = 'left';
								} elseif ( $data['heading_section']['heading_talign'] == 'wfacp-text-right' ) {
									$align_pos = 'right';
								} else {
									$align_pos = 'center';
								}
							}

							if ( isset( $data['heading_section']['heading_font_weight'] ) ) {
								if ( $data['heading_section']['heading_font_weight'] == 'wfacp-normal' ) {
									$font_weight_subs = 'normal';
								} else {
									$font_weight_subs = 'bold';
								}
							}

							$this->customizer_css['desktop'][ $subscription_target ]['text-align']  = $align_pos;
							$this->customizer_css['desktop'][ $subscription_target ]['font-weight'] = $font_weight_subs;

						}

						if ( isset( $data['sub_heading_section']['heading_fs'] ) ) {

							$subscription_target = 'body .wfacp_main_form #woocommerce_eu_vat_compliance #woocommerce_eu_vat_compliance_vat_number h3 + p';

							$this->wfacp_font_size( $data['sub_heading_section'], array(
								'section_key' => $section_key,
								'target_to'   => $subscription_target,
								'source_from' => 'heading_fs',
							) );

							if ( isset( $data['sub_heading_section']['heading_talign'] ) ) {
								if ( $data['sub_heading_section']['heading_talign'] == 'wfacp-text-left' ) {
									$align_pos = 'left';
								} elseif ( $data['sub_heading_section']['heading_talign'] == 'wfacp-text-right' ) {
									$align_pos = 'right';
								} else {
									$align_pos = 'center';
								}
							}

							if ( isset( $data['sub_heading_section']['heading_font_weight'] ) ) {
								if ( $data['sub_heading_section']['heading_font_weight'] == 'wfacp-normal' ) {
									$font_weight_subs = 'normal';
								} else {
									$font_weight_subs = 'bold';
								}
							}

							$this->customizer_css['desktop'][ $subscription_target ]['text-align']  = $align_pos;
							$this->customizer_css['desktop'][ $subscription_target ]['font-weight'] = $font_weight_subs;

						}

						$this->wfacp_font_size( $btn_arr, array(
							'section_key' => $section_key,
							'target_to'   => $btn_class,
							'source_from' => 'fs',
						) );

					}

					$this->customizer_fields_data['wfacp_form']['form_data']['btn_details'] = $btn_arr;

					$this->prepare_dynamic_style( $data, 'wfacp_main_form' );

					/* Set Font Size */
					$this->wfacp_font_size( $data['form_data'], array(
						'section_key' => $section_key,
						'target_to'   => '.wfacp_main_form label.wfacp-form-control-label',
						'source_from' => 'field_style',
					) );
					$this->wfacp_font_size( $data['sub_heading_section'], array(
						'section_key' => $section_key,
						'target_to'   => '.wfacp_main_form .wfacp-comm-title h4',
						'source_from' => 'heading_fs',
					) );

				} elseif ( $section_key == 'wfacp_form_cart' ) {
					$layout_key = '';
					if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
						$layout_key = $selected_template_slug . '_';
					}


					$data = array();

					if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
						$layout_key = $selected_template_slug . '_';
						if ( 'layout_9' == $selected_template_slug ) {
							$orderSidebarkey                                      = $section_key . '_section_' . $layout_key . 'enable_coupon_right_side_coupon';
							$data['order_hide_img']                               = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'order_hide_img' );
							$data['form_data']['enable_coupon_right_side_coupon'] = WFACP_Common::get_option( $orderSidebarkey );


						}
					}

					$data['wfacp_mini_cart_style']['mini_cart_typography_ff'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'mini_cart_typography_ff' );

					if ( isset( $data['wfacp_mini_cart_style']['mini_cart_typography_ff'] ) && $data['wfacp_mini_cart_style']['mini_cart_typography_ff'] != '' ) {
						$this->mini_cart_selected_font_family = $data['wfacp_mini_cart_style']['mini_cart_typography_ff'];
					}


					/*  Section Heading */

					$data['heading_section'] = $this->get_heading_section( $section_key, $selected_template_slug );


					$data_keys = $this->get_section_keys_data( 'wfacp_form_cart' );


					$form_color_meta = [
						'panel'    => $section_key,
						'section'  => 'section',
						'template' => $selected_template_slug,
						'key'      => 'colors',
					];
					$this->assign_colors( $data_keys, $form_color_meta );

					$data['advance_setting'] = $this->get_advance_setting( $section_key, $selected_template_slug );
					$data['colors']          = $this->get_color_setting( $section_key, $selected_template_slug );

					$this->customizer_fields_data[ $section_key ] = $data;

					$data['product_cart_coupon'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'order_hide_right_side_coupon' );

					$this->prepare_dynamic_style( $data, $section_key );

					/* Section Style */

					$this->customizer_fields_data[ $section_key ] = $data;

				} elseif ( $section_key == 'wfacp_form_product_switcher' ) {

					$data     = [];
					$products = WFACP_Common::get_page_product( WFACP_Common::get_id() );
					if ( is_array( $products ) && count( $products ) > 0 ) {

						$layout_key = '';
						if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
							$layout_key = $selected_template_slug . '_';
						}

						foreach ( $products as $product_key => $val ) {
							$data['products'][ $product_key ]['heading']     = WFACP_Common::get_option( $section_key . '_section_' . $this->get_template_slug() . '_' . $product_key . '_heading' );
							$data['products'][ $product_key ]['description'] = WFACP_Common::get_option( $section_key . '_section_' . $this->get_template_slug() . '_' . $product_key . '_description' );

						}

						$data['data']['hide_section'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'hide_section' );

						$data['border']['product_switcher_head']['border-style'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'rbox_border_type' );
						$data['border']['product_switcher_head']['border-width'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'rbox_border_width' );
						$data['border']['product_switcher_head']['border-color'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'rbox_border_color' );
						$data['border']['product_switcher_head']['padding']      = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'rbox_padding' );

						if ( is_array( $data['border']['product_switcher_head'] ) && count( $data['border']['product_switcher_head'] ) > 0 ) {
							foreach ( $data['border']['product_switcher_head'] as $key1 => $value1 ) {

								$unit = 'px';
								if ( $key1 == 'border-color' || $key1 == 'border-style' ) {
									$unit = '';
								}

								$this->customizer_css['desktop']['body .wfacp_main_form .wfacp_whats_included'][ $key1 ] = $value1 . $unit;
							}
						}

						$this->customizer_fields_data[ $section_key ] = $data;

						/*  Color field*/

						$data_keys = $this->get_section_keys_data( $section_key );

						$form_color_meta = [
							'panel'    => $section_key,
							'section'  => 'section',
							'template' => $selected_template_slug,
							'key'      => 'colors',
						];


						$this->assign_colors( $data_keys, $form_color_meta );

						$this->prepare_dynamic_style( $data, $section_key );
					}
				} elseif ( strpos( $section_key, 'wfacp_html_widget_' ) !== false ) {

					$section_key1 = 'html_widgets_' . $section_key;

					$data                                    = [];
					$data[ $section_key ]['advance_setting'] = $this->get_advance_setting( $section_key1, $selected_template_slug, true );


					/* Get html content data */
					$data[ $section_key ]['data'] = WFACP_Common::get_option( $section_key1 . '_html_content' );


					/* Color Setting  */
					$data[ $section_key ]['colors']               = $this->get_color_setting( $section_key1, $selected_template_slug, true );
					$this->customizer_fields_data[ $section_key ] = $data[ $section_key ];


					$this->prepare_dynamic_style( $data[ $section_key ], $section_key );


					if ( isset( $data[ $section_key ]['colors']['content_text_color'] ) ) {

						$html_content_color                                             = $data[ $section_key ]['colors']['content_text_color'];
						$this->customizer_css['desktop'][ "." . $section_key ]['color'] = $html_content_color;

					}
				}
			}

		}

		protected function get_field_css_ready( $template_slug, $field_index ) {
			$main_class = WFACP_Common::get_option( 'wfacp_form_form_fields_1_' . $template_slug . '_' . $field_index );
			if ( '' !== trim( $main_class ) ) {
				$main_class .= ' ' . WFACP_Common::get_option( 'wfacp_form_form_fields_1_' . $template_slug . '_' . $field_index . '_other_classes' );
			}

			return $main_class;
		}

		public function change_default_setting( $panel_details, $panel_key ) {
			$fields_data = $panel_details['sections']['section']['fields'];


			foreach ( $fields_data as $key => $value ) {
				if ( isset( $this->layout_setting[ $panel_key ][ $key ] ) ) {
					$panel_details['sections']['section']['fields'][ $key ]['default'] = $this->layout_setting[ $panel_key ][ $key ];
				}
			}

			return $panel_details;
		}

		public function order_btn_sticky( $panel_details, $panel_key ) {
			$selected_template_slug = $this->template_slug;
			if ( $panel_key == 'wfacp_form' ) {

				$pageID         = WFACP_Common::get_id();
				$_wfacp_version = WFACP_Common::get_post_meta_data( $pageID, '_wfacp_version' );

				if ( isset( $_wfacp_version ) && ! empty( $_wfacp_version ) ) {
					if ( isset( $panel_details['sections']['section']['fields'][ $selected_template_slug . '_btn_order-place_make_button_sticky_on_mobile' ] ) ) {
						$panel_details['sections']['section']['fields'][ $selected_template_slug . '_btn_order-place_make_button_sticky_on_mobile' ]['default'] = 'no_sticky';

					}
				}
			}

			return $panel_details;
		}

		public function multi_tab_default_setting( $panel_details, $panel_key ) {

			if ( empty( $panel_key ) || empty( $this->layout_setting ) ) {
				return $panel_details;

			}

			foreach ( $panel_key as $index_key => $value ) {
				if ( empty( $value ) ) {
					continue;
				}
				if ( ! isset( $this->layout_setting[ $index_key ] ) ) {
					continue;
				}
				foreach ( $value as $pkey => $pvalue ) {
					$fields_data = $panel_details['sections'][ $pvalue ]['fields'];
					if ( empty( $pvalue ) ) {
						continue;
					}
					foreach ( $fields_data as $key => $value ) {
						if ( array_key_exists( $key, $this->layout_setting[ $index_key ] ) ) {
							$panel_details['sections'][ $pvalue ]['fields'][ $key ]['default'] = $this->layout_setting[ $index_key ][ $key ];
						}
					}
				}
			}

			return $panel_details;
		}

		public function add_form_steps() {

			$selected_template_type = $this->get_template_type();

			$num_of_steps = $this->get_step_count();


			if ( $num_of_steps > 1 ) {


				$breadcrumb = [];
				if ( isset( $this->customizer_fields_data['wfacp_form']['form_data']['breadcrumb'] ) ) {
					$breadcrumb = $this->customizer_fields_data['wfacp_form']['form_data']['breadcrumb'];
				}

				if ( $selected_template_type != 'pre_built' ) {
					$bar = $this->customizer_fields_data['wfacp_form']['form_data']['bar'];

					if ( isset( $bar['disable_steps_bar'] ) ) {
						$disable_steps_bar = $bar['disable_steps_bar'];
						if ( $disable_steps_bar == true || $bar['select_type'] != 'breadcrumb' ) {
							return;
						}
					}
				}

				if ( is_array( $breadcrumb ) && count( $breadcrumb ) > 0 ) {

					$steps_arr = [ 'single_step', 'two_step', 'third_step' ];

					$breadcrumb = $this->customizer_fields_data['wfacp_form']['form_data']['breadcrumb'];

					echo '<div class=wfacp_steps_wrap>';
					echo '<div class=wfacp_steps_sec>';

					echo '<ul>';
					do_action( 'wfacp_before_breadcrumb', $breadcrumb );


					foreach ( $breadcrumb as $key => $value ) {
						$active = '';

						if ( $key == 0 ) {
							$active = 'wfacp_bred_active wfacp_bred_visited';
						}

						$step       = ( isset( $steps_arr[ $key ] ) ) ? $steps_arr[ $key ] : '';
						$text_class = ( ! empty( $value ) ) ? 'wfacp_step_text_have' : 'wfacp_step_text_nohave';
						echo "<li class='wfacp_step_$key wfacp_bred $active $step' step='$step'>";
						?>
                        <a href='javascript:void(0)' class="<?php echo $text_class; ?>" data-text="<?php echo sanitize_title( $value ); ?>"><?php echo $value; ?></a>
						<?php

						echo '</li>';
					}
					do_action( 'wfacp_after_breadcrumb' );
					echo '</ul></div></div>';
				}
			}
		}


		public function get_heading_section( $section_key, $selected_template_slug = '' ) {

			if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
				$selected_template_slug = $selected_template_slug . '_';
			} else {
				$selected_template_slug = '';
			}

			$heading_section = array();

			$enable_heading      = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . 'enable_heading' );
			$heading             = WFACP_Common::get_option( $section_key . '_section_heading' );
			$heading_font_size   = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . 'heading_fs' );
			$heading_talign      = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . 'heading_talign' );
			$heading_font_weight = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . 'heading_font_weight' );

			if ( isset( $enable_heading ) ) {
				$heading_section['enable_heading'] = $enable_heading;
			}
			if ( isset( $heading ) ) {
				$heading_section['heading'] = $heading;
			}
			if ( isset( $heading_font_size ) ) {
				$heading_section['heading_fs'] = $heading_font_size;
			}
			if ( isset( $heading_talign ) ) {
				$heading_section['heading_talign'] = $heading_talign;
			}

			if ( isset( $heading_font_weight ) ) {
				$heading_section['heading_font_weight'] = $heading_font_weight;
			}

			$heading_section = WFACP_Common::unset_blank_keys( $heading_section );

			return $heading_section;
		}

		public function get_advance_setting( $section_key, $selected_template_slug = '', $is_mult_tab = false ) {

			if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
				$selected_template_slug = $selected_template_slug . '_';
			} else {
				$selected_template_slug = '';
			}

			$section_inner_key = "_section_";
			if ( true === $is_mult_tab ) {


				$section_inner_key = "_";
			}

			$advanced_setting                      = array();
			$advanced_setting['rbox_border_type']  = WFACP_Common::get_option( $section_key . $section_inner_key . $selected_template_slug . 'rbox_border_type' );
			$advanced_setting['rbox_border_width'] = WFACP_Common::get_option( $section_key . $section_inner_key . $selected_template_slug . 'rbox_border_width' );
			$advanced_setting['rbox_border_color'] = WFACP_Common::get_option( $section_key . $section_inner_key . $selected_template_slug . 'rbox_border_color' );
			$advanced_setting['rbox_padding']      = WFACP_Common::get_option( $section_key . $section_inner_key . $selected_template_slug . 'rbox_padding' );

			$advanced_setting = WFACP_Common::unset_blank_keys( $advanced_setting );

			return $advanced_setting;
		}


		public function get_color_setting( $section_key, $selected_template_slug = '', $is_mult_tab = false ) {
			$color_setting = array();
			if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
				$selected_template_slug = $selected_template_slug . '_';
			} else {
				$selected_template_slug = '';
			}
			$section_inner_key = "_section_";
			if ( true === $is_mult_tab ) {
				$section_inner_key = "_";
			}

			$color_setting['section_bg_color']   = WFACP_Common::get_option( $section_key . $section_inner_key . $selected_template_slug . 'section_bg_color' );
			$color_setting['sec_heading_color']  = WFACP_Common::get_option( $section_key . $section_inner_key . $selected_template_slug . 'sec_heading_color' );
			$color_setting['heading_text_color'] = WFACP_Common::get_option( $section_key . $section_inner_key . $selected_template_slug . 'heading_text_color' );
			$color_setting['content_text_color'] = WFACP_Common::get_option( $section_key . $section_inner_key . $selected_template_slug . 'content_text_color' );

			$color_setting = WFACP_Common::unset_blank_keys( $color_setting );

			return $color_setting;
		}

		public function prepare_dynamic_style( $data, $section_key ) {

			/* Heading Setting Start */


			/* Font Size */
			if ( isset( $data['heading_section']['heading_fs'] ) ) {

				$heading_fs   = $data['heading_section']['heading_fs'];
				$default_unit = '';

				$desktop_fs = '';

				/* Desktop Font Size  */
				if ( isset( $heading_fs['desktop'] ) ) {
					$desktop_fs = $heading_fs['desktop'];
				}
				if ( isset( $heading_fs['desktop-unit'] ) ) {
					$default_unit = $heading_fs['desktop-unit'];
				}
				$desktop_font_size = $desktop_fs . $default_unit;

				$tablet_font_size = '';
				$tablet_fs        = '';

				/* Tablet Font Size  */
				if ( isset( $heading_fs['tablet'] ) && $heading_fs['tablet'] != '' ) {
					$tablet_fs = $heading_fs['tablet'];
				}
				if ( isset( $heading_fs['tablet-unit'] ) && $heading_fs['tablet-unit'] != '' ) {
					$default_unit = $heading_fs['tablet-unit'];
				}
				$tablet_font_size = $tablet_fs . $default_unit;

				/* Mobile Font Size  */
				$mobile_font_size = '';
				$mobile_fs        = '';

				if ( isset( $heading_fs['mobile'] ) && $heading_fs['mobile'] != '' ) {
					$mobile_fs = $heading_fs['mobile'];
				}
				if ( isset( $heading_fs['mobile-unit'] ) && $heading_fs['mobile-unit'] != '' ) {
					$default_unit = $heading_fs['mobile-unit'];
				}
				$mobile_font_size = $mobile_fs . $default_unit;

				if ( $desktop_font_size != '' ) {
					$this->customizer_css['desktop'][ '.' . $section_key . ' .wfacp_section_title' ] = [ 'font-size' => $desktop_font_size ];
				}

				if ( $tablet_font_size != '' ) {
					$this->customizer_css['tablet'][ '.' . $section_key . ' .wfacp_section_title' ] = [ 'font-size' => $tablet_font_size ];
				}
				if ( $mobile_font_size != '' ) {
					$this->customizer_css['mobile'][ '.' . $section_key . ' .wfacp_section_title' ] = [ 'font-size' => $mobile_font_size ];
				}

			}

			/* Text Alignment */
			$align_position = 'center';
			if ( isset( $data['heading_section']['heading_talign'] ) ) {
				$heading_talign = $data['heading_section']['heading_talign'];
				if ( $heading_talign == 'wfacp-text-center' ) {
					$align_position = 'center';
				} elseif ( $heading_talign == 'wfacp-text-left' ) {
					$align_position = 'left';
				} elseif ( $heading_talign == 'wfacp-text-right' ) {
					$align_position = 'right';
				}
				$this->customizer_css['desktop'][ '.' . $section_key . " .wfacp-text-$align_position" ] = array(
					'text-align' => $align_position,
				);
			}

			/* Font  Weight */
			if ( isset( $data['heading_section']['heading_font_weight'] ) ) {
				$font_weight = $data['heading_section']['heading_font_weight'];
				if ( $font_weight == 'wfacp-normal' ) {
					$weight_size = 'normal';
				} elseif ( $font_weight == 'wfacp-bold' ) {
					$weight_size = 'bold';
				}
				$this->customizer_css['desktop'][ '.' . $section_key . " .wfacp-$weight_size" ] = array(
					'font-weight' => $weight_size,
				);
			}

			/* Advanced Setting Start*/
			$additional_setting = array();


			$rbox_border_type = '';
			if ( isset( $data['advance_setting']['rbox_border_type'] ) ) {
				$rbox_border_type                   = $data['advance_setting']['rbox_border_type'];
				$additional_setting['border-style'] = $rbox_border_type;

			}
			if ( isset( $data['advance_setting']['rbox_border_width'] ) ) {
				$rbox_border_width                  = $data['advance_setting']['rbox_border_width'];
				$additional_setting['border-width'] = $rbox_border_width . 'px';
			}
			if ( isset( $data['advance_setting']['rbox_border_color'] ) ) {
				$rbox_border_color                  = $data['advance_setting']['rbox_border_color'];
				$additional_setting['border-color'] = $rbox_border_color;
			}
			if ( isset( $data['advance_setting']['rbox_padding'] ) ) {
				$rbox_padding = $data['advance_setting']['rbox_padding'];

				$additional_setting['padding'] = $rbox_padding . 'px';
			}
			/* Advanced Setting Closed */

			/* Color Setting Start */
			if ( isset( $data['colors']['section_bg_color'] ) ) {
				$section_bg_color = $data['colors']['section_bg_color'];

				$additional_setting['background-color'] = $section_bg_color;
			}


			if ( isset( $data['colors']['sec_heading_color'] ) ) {
				$sec_heading_color                                                                = $data['colors']['sec_heading_color'];
				$this->customizer_css['desktop'][ '.' . $section_key . ' .wfacp_section_title ' ] = array(
					'color' => $sec_heading_color,
				);
			}

			if ( isset( $data['colors']['content_text_color'] ) ) {
				$content_text_color                                            = $data['colors']['content_text_color'];
				$this->customizer_css['desktop'][ '.' . $section_key . ' p ' ] = array(
					'color' => $content_text_color,
				);
			}
			if ( ( is_array( $additional_setting ) && count( $additional_setting ) > 0 ) ) {
				$this->customizer_css['desktop'][ '.' . $section_key ] = $additional_setting;

			}


		}

		public function get_sub_heading_section( $section_key, $selected_template_slug = '' ) {


			if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
				$selected_template_slug = $selected_template_slug . '_';
			} else {
				$selected_template_slug = '';
			}

			$heading_section = array();

			$enable_sub_heading      = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . 'enable_sub_heading' );
			$sub_heading             = WFACP_Common::get_option( $section_key . '_section_sub_heading' );
			$sub_heading_fs          = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . 'sub_heading_fs' );
			$sub_heading_talign      = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . 'sub_heading_talign' );
			$sub_heading_font_weight = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . 'sub_heading_font_weight' );

			if ( isset( $enable_sub_heading ) && $enable_sub_heading != '' ) {
				$heading_section['enable_heading'] = $enable_sub_heading;
			}
			if ( isset( $sub_heading ) && $sub_heading != '' ) {
				$heading_section['heading'] = $sub_heading;
			}
			if ( isset( $sub_heading_fs ) && $sub_heading_fs != '' ) {
				$heading_section['heading_fs'] = $sub_heading_fs;
			}

			if ( isset( $sub_heading_talign ) && $sub_heading_talign != '' ) {
				$heading_section['heading_talign'] = $sub_heading_talign;
			}

			if ( isset( $sub_heading_font_weight ) && $sub_heading_font_weight != '' ) {
				$heading_section['heading_font_weight'] = $sub_heading_font_weight;
			}


			$heading_section = WFACP_Common::unset_blank_keys( $heading_section );

			return $heading_section;
		}

		public function get_section_keys_data( $section_key ) {
			if ( isset( $this->section_keys_data[ $section_key ] ) ) {
				return $this->section_keys_data[ $section_key ];
			}

			return $section_key;
		}

		public function set_section_keys_data( $section_key, $data ) {

			$this->section_keys_data[ $section_key ] = $data;
		}

		public function assign_colors( $data_keys, $form_color_meta = [] ) {
			$prefix_key = '';
			$panel_name = '';

			if ( isset( $form_color_meta['panel'] ) && $form_color_meta['panel'] != '' ) {
				$prefix_key = $prefix_key . $form_color_meta['panel'] . '_';
				$panel_name = $form_color_meta['panel'];
			}

			if ( isset( $form_color_meta['section'] ) && $form_color_meta['section'] != '' ) {
				$prefix_key = $prefix_key . $form_color_meta['section'] . '_';
			}

			$data = [];
			if ( ! is_array( $data_keys ) || count( $data_keys ) == 0 || $prefix_key == '' ) {
				return;
			}


			$local_css = [];
			$temp_type = $this->get_template_type();


			foreach ( $data_keys['colors'] as $key => $details ) {

				$key_name = $key;

				$important_to_class = '';


				if ( $panel_name == 'wfacp_form' && strpos( $key, '_next_' ) !== false ) {
					$key_name = str_replace( '_next_', '_order-place_', $key );
				}

				$data[ $form_color_meta['key'] ][ $key ] = WFACP_Common::get_option( $prefix_key . $key_name );

				if ( ! isset( $data[ $form_color_meta['key'] ][ $key ] ) || $data[ $form_color_meta['key'] ][ $key ] == '' ) {

					continue;
				}


				foreach ( $details as $index => $value ) {
					$device      = $value['device'];
					$class       = $value['class'];
					$type        = $value['type'];
					$field_value = $data[ $form_color_meta['key'] ][ $key ];

					if ( isset( $device ) && isset( $class ) && isset( $type ) && isset( $field_value ) ) {

						if ( $temp_type == 'embed_form' && defined( 'ET_CORE_VERSION' ) ) {
							if ( strpos( $key_name, 'btn_order-place' ) !== false && ( $type == 'background-color' || $type == 'color' ) ) {

								$important_to_class = ' !important';
							}
						}

						$this->customizer_css[ $device ][ $class ][ $type ] = $field_value . $important_to_class;

						$local_css[ $device ][ $class ][ $type ] = $field_value . $important_to_class;
					}
				}
			}

			if ( $panel_name == '' ) {
				return;
			}

			foreach ( $data as $key => $value ) {
				$this->customizer_fields_data[ $panel_name ][ $key ] = $value;
			}

		}

		public function wfacp_font_size( $data, $metaData ) {

			extract( $metaData );

			if ( ! isset( $section_key ) || ! isset( $target_to ) || ! isset( $source_from ) ) {
				return;
			}

			if ( isset( $data[ $source_from ] ) ) {
				$heading_fs = $data[ $source_from ];
			}


			$desktop_fs   = '';
			$tablet_fs    = '';
			$mobile_fs    = '';
			$default_unit = 'px';

			/* Desktop Font Size  */
			if ( isset( $heading_fs['desktop'] ) ) {
				$desktop_fs = $heading_fs['desktop'];
			}
			if ( isset( $heading_fs['desktop-unit'] ) ) {
				$default_unit = $heading_fs['desktop-unit'];
			}

			$desktop_font_size = $desktop_fs . $default_unit;

			/* Tablet Font Size  */

			if ( isset( $heading_fs['tablet'] ) ) {
				$tablet_fs = $heading_fs['tablet'];
			}
			if ( isset( $heading_fs['tablet-unit'] ) ) {
				$default_unit = $heading_fs['tablet-unit'];
			}

			$tablet_font_size = $tablet_fs . $default_unit;

			/* Mobile Font Size  */

			if ( isset( $heading_fs['mobile'] ) ) {
				$mobile_fs = $heading_fs['mobile'];
			}

			if ( isset( $heading_fs['mobile-unit'] ) ) {
				$default_unit = $heading_fs['mobile-unit'];
			}
			$mobile_font_size = $mobile_fs . $default_unit;

			if ( isset( $this->customizer_css['desktop'][ $target_to ] ) && is_array( $this->customizer_css['desktop'][ $target_to ] ) && count( $this->customizer_css['desktop'][ $target_to ] ) > 0 ) {

				if ( isset( $desktop_font_size ) ) {
					$this->customizer_css['desktop'][ $target_to ]['font-size'] = $desktop_font_size;
				}

				if ( isset( $tablet_font_size ) ) {

					$this->customizer_css['tablet'][ $target_to ]['font-size'] = $tablet_font_size;

				}
				if ( isset( $mobile_font_size ) ) {
					$this->customizer_css['mobile'][ $target_to ]['font-size'] = $mobile_font_size;
				}
			} else {

				if ( isset( $desktop_font_size ) ) {
					$this->customizer_css['desktop'][ $target_to ] = array(
						'font-size' => $desktop_font_size,
					);

				}
				if ( isset( $tablet_font_size ) ) {
					$this->customizer_css['tablet'][ $target_to ] = array(
						'font-size' => $tablet_font_size,
					);
				}
				if ( isset( $mobile_font_size ) ) {
					$this->customizer_css['mobile'][ $target_to ] = array(
						'font-size' => $mobile_font_size,
					);
				}
			}

		}

		public function get_customizer_data() {

			$customizer_support     = apply_filters( 'wfacp_customizer_supports', $this->available_fields );
			$template_slug          = $this->get_template_slug();
			$this->web_google_fonts = bwf_get_fonts_list( 'name_key' );
			$this->customizer_data  = apply_filters( 'wfacp_before_customizer_fieldset', $this->customizer_data, $this );
			if ( in_array( 'layout', $customizer_support ) ) {
				/** PANEL: LAYOUT */
				require_once __DIR__ . '/customizer-options/class-section-layout.php';
				/* Customer Suppor Layout */
				require_once __DIR__ . '/customizer-options/class-section-customer-care.php';
				$layout_panel            = WFACP_Sectionlayout::get_instance( $this )->layout_settings();
				$this->customizer_data[] = $layout_panel;

			}

			if ( in_array( 'header', $customizer_support ) ) {
				/** PANEL: HEADER */
				require_once __DIR__ . '/customizer-options/class-section-header.php';
				$header_panel            = WFACP_SectionHeader::get_instance( $this )->header_settings();
				$this->customizer_data[] = $header_panel;
			}

			if ( in_array( 'product', $customizer_support ) ) {
				/* Product PRODUCT */
				require_once __DIR__ . '/customizer-options/class-section-product-details.php';
				$productDetails_panel    = WFACP_SectionProductDetails::get_instance( $this )->productDetails_settings();
				$this->customizer_data[] = $productDetails_panel;
			}

			if ( in_array( 'gbadge', $customizer_support ) ) {
				/* Guarantee Badge GUARANTEE BADGE */
				require_once __DIR__ . '/customizer-options/class-section-guarantee-badge.php';
				$gbadge_panel            = WFACP_SectionGbadge::get_instance( $this )->gbadge_settings();
				$this->customizer_data[] = $gbadge_panel;
			}

			if ( in_array( 'listing', $customizer_support ) ) {
				/* Benefits BANEFITS */
				require_once __DIR__ . '/customizer-options/class-section-listing.php';
				$list_panel              = WFACP_SectionListing::get_instance( $this )->listing_settings();
				$this->customizer_data[] = $list_panel;
			}
			if ( in_array( 'testimonial', $customizer_support ) ) {
				/* Testimonial  */
				require_once __DIR__ . '/customizer-options/class-section-testimonial.php';
				$testimonial_panel       = WFACP_SectionTestimonial::get_instance( $this )->testimonial_settings();
				$this->customizer_data[] = $testimonial_panel;
			}
			if ( in_array( 'widget', $customizer_support ) ) {
				/* Assurance  */
				require_once __DIR__ . '/customizer-options/class-section-twidget.php';
				$twidget_panel           = WFACP_SectionTwidget::get_instance( $this )->twidget_settings();
				$this->customizer_data[] = $twidget_panel;
			}

			if ( in_array( 'customer-care', $customizer_support ) ) {
				/* Customer Suppor Layout */
				require_once __DIR__ . '/customizer-options/class-section-customer-care.php';
				$customer_care_panel     = WFACP_SectionCustomerCare::get_instance( $this )->customer_care_settings();
				$this->customizer_data[] = $customer_care_panel;
			}

			if ( in_array( 'promises', $customizer_support ) ) {
				/* Promises Layout */
				require_once __DIR__ . '/customizer-options/class-section-promises.php';
				$promises_panel          = WFACP_SectionPromises::get_instance( $this )->promises_settings();
				$this->customizer_data[] = $promises_panel;
			}


			/** PANEL: Form LAYOUT */
			require_once __DIR__ . '/customizer-options/class-section-form.php';
			$form_panel              = WFACP_SectionForm::get_instance( $this )->form_settings();
			$this->customizer_data[] = $form_panel;


			if ( in_array( 'html_widget_1', $customizer_support ) ) {

				/* Html Widget Layout */
				require_once __DIR__ . '/customizer-options/class-section-html-widget.php';
				$html_widget_settings_panel_1 = WFACP_SectionHtmlWidgets::get_instance( $this )->html_widget_settings();
				$this->customizer_data[]      = $html_widget_settings_panel_1;

			}


			if ( in_array( 'footer', $customizer_support ) ) {
				/** PANEL: FOOTER */
				require_once __DIR__ . '/customizer-options/class-section-footer.php';
				$footer_panel            = WFACP_SectionFooter::get_instance( $this )->footer_settings();
				$this->customizer_data[] = $footer_panel;
			}

			/** PANEL: Product Switcher*/
			require_once __DIR__ . '/customizer-options/class-product-switcher.php';
			$switcher_settings       = WFACP_Product_Switcher_Field::get_instance( $this )->get_settings();
			$this->customizer_data[] = $switcher_settings;

			if ( 'layout_9' !== $template_slug ) {

				/** PANEL: Order Summary */
				require_once WFACP_BUILDER_DIR . '/customizer/customizer-options/class-section-order-summary.php';
				$orderSummary_setting    = WFACP_Section_Order_Summary::get_instance( $this )->order_summary_settings();
				$this->customizer_data[] = $orderSummary_setting;
			}


			/** PANEL: STYLE */
			require_once __DIR__ . '/customizer-options/class-section-styles.php';
			$style_panel             = WFACP_SectionStyles::get_instance( $this )->style_settings();
			$this->customizer_data[] = $style_panel;


			/** PANEL: Custom CSS LAYOUT */
			require_once __DIR__ . '/customizer-options/class-section-custom-css.php';
			$css_panel               = WFACP_SectionCustomCss::get_instance( $this )->custom_css_settings();
			$this->customizer_data[] = $css_panel;


			$this->customizer_data = apply_filters( 'wfacp_customizer_fieldset', $this->customizer_data, $this );

			/** Set default values against all customizer keys */
			WFACP_Common::set_customizer_fields_default_vals( $this->customizer_data );

		}


		public function get_sections() {
			return $this->sections;
		}

		public function get_section( $wp_customize = false ) {
			/** WFACPKirki is required to customizer */
			if ( ! class_exists( 'WFACPKirki' ) ) {
				return;
			}

			if ( false == $wp_customize ) {
				return;
			}

			if ( ! is_array( $this->customizer_data ) || count( $this->customizer_data ) == 0 ) {
				return;
			}

			foreach ( $this->customizer_data as $panel_single ) {
				foreach ( $panel_single as $panel_key => $panel_arr ) {
					/** Panel */
					$maybe_panel = true;
					if ( isset( $panel_arr['panel'] ) && 'no' == $panel_arr['panel'] ) {
						/** No need to register panel */
						$maybe_panel = false;
					} else {
						$arr = $panel_arr['data'];
						$arr = array_merge( $arr, array(
							'capability'     => 'edit_theme_options',
							'theme_supports' => '',
						) );
						$wp_customize->add_panel( $panel_key, $arr );
					}

					if ( ! is_array( $panel_arr['sections'] ) || count( $panel_arr['sections'] ) == 0 ) {
						continue;
					}

					/** Section */

					foreach ( $panel_arr['sections'] as $section_key => $section_arr ) {
						$section_key_final = $panel_key . '_' . $section_key;

						$this->sections[] = $section_key_final;

						if ( isset( $section_arr['data'] ) ) {
							$arr = $section_arr['data'];
						}

						if ( true === $maybe_panel ) {
							$arr = array_merge( $arr, array(
								'panel' => $panel_key,
							) );
						}

						$wp_customize->add_section( $section_key_final, $arr );

						/** Fields - will add using wfacpkirki */

						/** Set the selective part */
						if ( ! is_array( $section_arr['fields'] ) || count( $section_arr['fields'] ) == 0 ) {
							continue;
						}

						foreach ( $section_arr['fields'] as $field_key => $field_data ) {
							$field_key_final = $section_key_final . '_' . $field_key;
							$field_key_final = WFACP_Core()->customizer->customizer_key_prefix . '[' . $field_key_final . ']';

							/** Checking if wfacp_partial class exist */
							if ( ! isset( $field_data['wfacp_partial'] ) || ! is_array( $field_data['wfacp_partial'] ) || ! isset( $field_data['wfacp_partial']['elem'] ) ) {
								continue;
							}

							$callback = isset( $field_data['wfacp_partial']['callback'] ) ? $field_data['wfacp_partial']['callback'] : 'render_callback';

							$wp_customize->selective_refresh->add_partial( $field_key_final, array(
								'selector'        => $field_data['wfacp_partial']['elem'],
								'render_callback' => array( $this, $callback ),
								'primary_setting' => $field_key_final,
							) );

						}
					}
				}
			}
		}


		public function render_callback( $data ) {

			$partial_key_base = $data->id_data();
			if ( is_array( $partial_key_base ) && isset( $partial_key_base['keys'] ) ) {
				$partial_key         = $partial_key_base['keys'][0];
				switch ( $partial_key ) {
					case 'wfacp_header_top_logo':
						$logo = WFACP_Common::get_option( $partial_key );
						$no_logo_img = WFACP_PLUGIN_URL . '/admin/assets/img/no_logo.jpg';
						?>
                        <img src="<?php echo $logo ? $logo : $no_logo_img; ?>" alt="<?php bloginfo( 'name' ); ?>"
                             title="<?php bloginfo( 'name' ); ?>"/>
						<?php
						$logo_img_html = ob_get_clean();

						return $logo_img_html;
						break;
					default:
						$value = WFACP_Common::get_option( $partial_key );
						if ( ! empty( $value ) ) {
							$value = nl2br( $value );
						}

						return $value;
						break;
				}
			}
		}


		public function wfacp_header_logo( $data ) {
			$partial_key_base = $data->id_data();

			if ( is_array( $partial_key_base ) && isset( $partial_key_base['keys'] ) ) {
				$partial_key = $partial_key_base['keys'][0];
				$logo        = WFACP_Common::get_option( $partial_key );
				$no_logo_img = $this->img_path . 'woo_checkout_logo.png';

				ob_start();
				?>


                <img class="wfacp-logo" src="<?php echo $logo ? $logo : $no_logo_img; ?>" alt="<?php the_title() ?>">


				<?php
				$wfacp_header_logo = ob_get_clean();

				return $wfacp_header_logo;
			}
		}

		public function wfacp_changed_step_text( $data ) {
			$partial_key_base = $data->id_data();

			if ( is_array( $partial_key_base ) && isset( $partial_key_base['keys'] ) ) {
				$partial_key     = $partial_key_base['keys'][0];
				$step_value_text = WFACP_Common::get_option( $partial_key );
				$text_class_nner = ( ! empty( $step_value_text ) ) ? 'wfacp_step_text_have' : 'wfacp_step_text_nohave';

				ob_start();
				?>
                <a href='javascript:void(0)' class="<?php echo $text_class_nner; ?>"><?php echo $step_value_text; ?></a>
				<?php
				$step_value_text_html = ob_get_clean();

				return $step_value_text_html;
			}
		}

		public function form_pop_up_content() {
			?>

            <div id="wfacp_form_popup_content" style="display: none;">

                <h3>
					<?php _e( 'CSS Ready Classes', 'woofunnels-aero-checkout' ); ?>
                </h3>
                <div class="wfacp_des_wrap">
					<?php _e( 'Here are set of CSS classes that can be used to style the checkout form', 'woofunnels-aero-checkout' ); ?>

                </div>


                <table class="table widefat">
                    <thead>
                    <tr>
                        <td><?php _e( 'Title', 'woofunnels-aero-checkout' ); ?></td>
                        <td style="width: 70%;">
							<?php _e( 'Classes', 'woofunnels-aero-checkout' ); ?>
                        </td>

                    </tr>
                    </thead>
                    <tbody>

                    <tr>
                        <td><?php _e( 'To create full width field', 'woofunnels-aero-checkout' ); ?></td>
                        <td><input type="text" readonly onClick="this.select()" value='wfacp-col-full'/></td>
                    </tr>

                    <tr>
                        <td><?php _e( 'To create two columns structure and set field left side', 'woofunnels-aero-checkout' ); ?></td>
                        <td><input type="text" readonly onClick="this.select()" value='wfacp-col-left-half'/></td>
                    </tr>

                    <tr>
                        <td><?php _e( 'To create three columns structure and set field left side', 'woofunnels-aero-checkout' ); ?></td>
                        <td><input type="text" readonly onClick="this.select()" value='wfacp-col-left-third'/></td>
                    </tr>


                    <tr>
                        <td><?php _e( 'To create two third columns structure', 'woofunnels-aero-checkout' ); ?></td>
                        <td><input type="text" readonly onClick="this.select()" value='wfacp-col-two-third'/></td>
                    </tr>
                    <tr>
                        <td><?php _e( 'To create field from new line use clearfix', 'woofunnels-aero-checkout' ); ?></td>
                        <td><input type="text" readonly onClick="this.select()" value='wfacp-col-clearfix'/></td>
                    </tr>


                    </tbody>


                </table>

            </div>

			<?php
		}

		public function get_excluded_sidebar_sections() {
			return $this->excluded_sidebar_sections;
		}

		public function active_sidebar() {
			return $this->current_active_sidebar = WFACP_Common::get_option( 'wfacp_layout_section_' . $this->template_slug . '_sidebar_layout_order' );
		}

		public function excluded_other_widget() {

			$other_layout_widget = WFACP_Common::get_option( 'wfacp_layout_section_' . $this->template_slug . '_other_layout_widget' );

			$tempArr = [];
			if ( is_array( $other_layout_widget ) && count( $other_layout_widget ) > 0 ) {
				$this->current_active_sidebar = $other_layout_widget;
				$tempArr                      = $this->current_active_sidebar;
			}

			return $tempArr;
		}

		final public function get_module( $data, $return, $type, $section_key ) {

			$file_path = WFACP_TEMPLATE_MODULE_DIR;
			if ( 'wfacp_html_widget' === $type ) {
				$file_path = WFACP_TEMPLATE_COMMON . '/template-parts/sections';
			}


			if ( ! $return && ( $type != '' ) ) {

				if ( file_exists( $file_path . '/' . $type . '.php' ) ) {

					include( $file_path . '/' . $type . '.php' );

				}
			}

		}


		public function add_class_change_place_order( $btn_html ) {


			$stepCount         = $this->get_step_count();
			$get_template_slug = $this->get_template_slug();
			$get_template_type = $this->get_template_type();


			if ( ! empty( $_GET['woo-paypal-return'] ) && ! empty( $_GET['token'] ) && ! empty( $_GET['PayerID'] ) ) {
				return $btn_html;
			}


			$alignmentclass = '';
			$width_cls      = '';

			if ( $stepCount > 1 ) {
				$alignmentclass = WFACP_Common::get_option( 'wfacp_form_section_' . $get_template_slug . '_btn_order-place_talign' );
				$width_cls1     = WFACP_Common::get_option( 'wfacp_form_section_' . $get_template_slug . '_btn_order-place_width' );
				if ( 'initial' === $width_cls1 ) {
					$width_cls = $width_cls1;

				}

			}


			ob_start();

			echo sprintf( '<div class="wfacp-order-place-btn-wrap %s %s">', $alignmentclass, $width_cls );

			echo $btn_html;

			if ( $stepCount > 1 ) {
				$last_step = 'single_step';
				if ( $this->current_step == 'third_step' ) {
					$last_step = 'two_step';
				}

				$getKey = $stepCount - 2;

				$back_btn_text = WFACP_Common::get_option( 'wfacp_form_section_back_btn_text' );


				if ( '' === $back_btn_text && 'pre_built' === $get_template_type ) {
					$back_btn_text = '&laquo; Return to {step_name}';
				}

				if ( strpos( $back_btn_text, '{step_name}' ) !== false ) {
					if ( 'pre_built' === $get_template_type ) {
						$sectionKeyText = strtolower( WFACP_Common::get_option( 'wfacp_form_section_breadcrumb_' . $getKey . '_step_text' ) );
					}

					if ( 'embed_forms_2' === $get_template_type || 'embed_form' === $get_template_type ) {
						$sectionKeyText = strtolower( WFACP_Common::get_option( 'wfacp_form_section_embed_forms_2_name_' . $getKey ) );

					}

					$back_btn_text = str_replace( "{step_name}", "$sectionKeyText", $back_btn_text );

				}
				$back_text = __( '&laquo; Return', 'woofunnels-aero-checkout' );

				if ( ! isset( $back_btn_text ) || $back_btn_text == '' ) {
					$back_btn_text = $back_text;
				}
				$back_link_text = "<div class='place_order_back_btn wfacp_none_class '><a class='wfacp_back_page_button' data-next-step='" . $last_step . "' data-current-step='" . $this->current_step . "' href='javascript:void(0)'>" . __( $back_btn_text, 'woofunnels-aero-checkout' ) . '</a> </div>';

				echo apply_filters( 'wfacp_back_link_text', $back_link_text );

			}


			echo '</div>';

			$orderPlaceHtml = ob_get_clean();

			return $orderPlaceHtml;
		}


		public function change_place_order_button_text( $order_button_text ) {

			$status = $this->exclude_place_order_text_update_order_review( $order_button_text );
			if ( true === $status ) {
				return $order_button_text;
			}
			$template_slug = $this->template_slug;

			$orderText = WFACP_Common::get_option( 'wfacp_form_section_' . $template_slug . '_btn_order-place_btn_text' );

			$order_total                        = '';
			$enable_price_in_place_order_button = WFACP_Common::get_option( 'wfacp_form_section_' . $template_slug . '_enable_price_in_place_order_button' );

			if ( isset( $enable_price_in_place_order_button ) && true === wc_string_to_bool( $enable_price_in_place_order_button ) ) {
				$order_total = "&nbsp;&nbsp;" . WFACP_Common::wfacp_order_total( [] );
			}

			if ( isset( $orderText ) && $orderText != '' ) {
				$this->place_order_btn_text = $orderText . $order_total;

				return $this->place_order_btn_text;
			}

			$text                       = strtoupper( $order_button_text ) . $order_total;
			$this->place_order_btn_text = $text;

			return $text;
		}

		public function change_single_step_label( $name, $current_action ) {

			$get_template_type = $this->template_type;


			if ( isset( $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['btn_text']['next'] ) && $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['btn_text']['next'] != '' ) {

				$nextButtonText = $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['btn_text']['next'];

				$getKey = 1;
				if ( 'embed_forms_2' === $get_template_type || 'embed_form' === $get_template_type ) {
					$sectionKeyText = strtolower( WFACP_Common::get_option( 'wfacp_form_section_embed_forms_2_name_' . $getKey ) );


					$nextButtonText = str_replace( "{step_name}", $sectionKeyText, $nextButtonText );

					return $nextButtonText;
				}


				if ( strpos( $nextButtonText, '{step_name}' ) !== false ) {

					if ( $current_action == 'single_step' ) {


						$sectionKeyText = strtolower( WFACP_Common::get_option( 'wfacp_form_section_breadcrumb_' . $getKey . '_step_text' ) );

						$back_btn_text = str_replace( "{step_name}", $sectionKeyText, $nextButtonText );


						return $back_btn_text;
					}

					return $nextButtonText;
				}


				return $nextButtonText;

			}


			return $name . '  →';
		}

		public function change_two_step_label( $name, $current_action ) {


			$get_template_type = $this->get_template_type();
			if ( isset( $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['btn_text']['back'] ) && $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['btn_text']['back'] != '' ) {


				$nextButtonText = $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['btn_text']['back'];


				$getKey = 2;
				if ( $current_action == 'two_step' && ( 'embed_forms_2' === $get_template_type || 'embed_form' === $get_template_type ) ) {
					$sectionKeyText = strtolower( WFACP_Common::get_option( 'wfacp_form_section_embed_forms_2_name_' . $getKey ) );


					$nextButtonText = str_replace( "{step_name}", $sectionKeyText, $nextButtonText );

					return $nextButtonText;
				}

				if ( strpos( $nextButtonText, '{step_name}' ) !== false ) {
					if ( $current_action == 'two_step' ) {
						$getKey         = 2;
						$sectionKeyText = strtolower( WFACP_Common::get_option( 'wfacp_form_section_breadcrumb_' . $getKey . '_step_text' ) );
						$back_btn_text  = str_replace( "{step_name}", $sectionKeyText, $nextButtonText );

						return $back_btn_text;
					}

					return $nextButtonText;
				}

				return $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['btn_text']['back'];


			}


			return $name . '→';
		}


		public function change_back_step_label( $text, $next_action, $current_action ) {

			$get_template_type = $this->get_template_type();

			$back_btn_text = WFACP_Common::get_option( 'wfacp_form_section_back_btn_text' );

			if ( $next_action == 'single_step' ) {
				$sectionKeyText = strtolower( WFACP_Common::get_option( 'wfacp_form_section_breadcrumb_0_step_text' ) );
			} else if ( $next_action == 'two_step' ) {
				$sectionKeyText = strtolower( WFACP_Common::get_option( 'wfacp_form_section_breadcrumb_1_step_text' ) );
			}

			if ( 'embed_forms_2' === $get_template_type || 'embed_form' === $get_template_type ) {

				if ( $next_action == 'single_step' ) {
					$sectionKeyText = strtolower( WFACP_Common::get_option( 'wfacp_form_section_embed_forms_2_name_0' ) );

				} else if ( $next_action == 'two_step' ) {
					$sectionKeyText = strtolower( WFACP_Common::get_option( 'wfacp_form_section_embed_forms_2_name_1' ) );

				}
			}

			if ( '' === $back_btn_text && WFACP_Core()->customizer->is_customizer_template( $get_template_type ) ) {
				$back_btn_text = '&laquo; Return to {step_name}';
			}

			if ( WFACP_Core()->customizer->is_customizer_template( $get_template_type ) && strpos( $back_btn_text, '{step_name}' ) !== false ) {
				$back_btn_text = str_replace( "{step_name}", "<span>$sectionKeyText</span>", $back_btn_text );
				$back_btn_text = strip_tags( $back_btn_text );

			}

			if ( isset( $back_btn_text ) && $back_btn_text != '' ) {
				return $back_btn_text;
			}


			return '&laquo; Return';
		}

		public function display_back_button( $step, $current_step ) {

			$alignmentclass = '';
			$width_cls      = '';
			if ( isset( $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['talign'] ) ) {
				$alignmentclass = $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['talign'];
			}

			if ( isset( $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['width'] ) ) {
				$width_cls1 = $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['width'];
				if ( 'initial' === $width_cls1 ) {
					$width_cls = $width_cls1;
				} else {
					$alignmentclass = 'left';
					$width_cls      = 'wfacp_full_with_btn';
				}
			}


			if ( 'single_step' != $step && $step != $current_step ) {


				echo sprintf( '<div class="sec_text_wrap %s %s">', $alignmentclass, $width_cls );

				echo '<div class=btm_btn_sec>';

				$this->get_back_button( $step );
				echo '</div>';
			}
		}


		public function payment_button_text() {
			return WFACP_Common::get_option( 'wfacp_form_section_' . $this->template_slug . '_btn_order-place_btn_text' );
		}

		public function call_before_cart_link( $breadcrumb ) {


			$is_global_checkout = WFACP_Core()->public->is_checkout_override();
			$before_link        = $this->customizer_fields_data['wfacp_form']['form_data']['breadcrumb_before'];
			if ( ! is_array( $before_link ) || count( $before_link ) == 0 ) {
				return;
			}


			if ( ( WFACP_Common::is_customizer() || $is_global_checkout === true ) ) {


				if ( isset( $before_link['enable_cart'] ) && $before_link['enable_cart'] == 1 ) {

					$slug         = $this->get_template_slug();
					$inline_width = '';
					if ( $slug == 'layout_9' ) {
						$header_layout_is = $this->get_temaplete_header_layout();
						if ( $header_layout_is != 'outside_header' ) {
							$breadcrumb_count = sizeof( $breadcrumb ) + 1;
							$steps_count      = 100 / $breadcrumb_count;

							$width_calc   = number_format( $steps_count, 0 ) . "%";
							$inline_width = "style=width:$width_calc";
						}

					}


					$cartURL  = wc_get_cart_url();
					$cartName = __( $before_link['enable_cart_text'], 'woocommerce' );

					echo "<li class='df_cart_link wfacp_bred_visited' $inline_width><a href='$cartURL'>$cartName</a></li>";
				}
			}


		}

		public function change_setting_for_default_checkout( $field, $key ) {

			$selected_template_slug = $this->get_template_slug();
			$selected_template_type = $this->get_template_type();
			$num_of_steps           = $this->get_step_count();
			$current_version        = WFACP_Common::get_checkout_page_version();

			if ( $key == 'wfacp_form' && $selected_template_type != 'embed_form' && $num_of_steps > 1 ) {

				$field['sections']['section']['fields'][ $selected_template_slug . '_enable_cart_in_breadcrumb' ] = [
					'type'        => 'checkbox',
					'label'       => __( 'Add cart link to progress bar', 'woofunnels-aero-checkout' ),
					'description' => 'This Setting works for global checkout',
					'priority'    => 9,
					'default'     => true,
				];
				$field['sections']['section']['fields']['cart_text']                                              = [
					'type'            => 'text',
					'label'           => __( 'Cart Title', 'woofunnels-aero-checkout' ),
					'priority'        => 9,
					'default'         => __( 'Cart', 'woofunnels-aero-checkout' ),
					'transport'       => 'postMessage',
					'active_callback' => [
						[
							'setting'  => 'wfacp_form_section_' . $selected_template_slug . '_enable_cart_in_breadcrumb',
							'operator' => '=',
							'value'    => true,
						],
					],
					'wfacp_transport' => [
						[
							'type'                => 'html',
							'container_inclusive' => false,
							'elem'                => '.wfacp_steps_sec .df_cart_link a',
						],
					],
				];
			} else if ( $key == 'wfacp_testimonials_0' && $selected_template_type != 'embed_form' ) {

				$default       = $field['sections']['section']['fields']['testimonials']['default'];
				$final_default = [];
				if ( version_compare( $current_version, '1.9.3', '>=' ) ) {
					if ( is_array( $default ) && count( $default ) > 0 ) {
						foreach ( $default as $key => $value ) {
							if ( isset( $value['tdate'] ) ) {
								$value['tdate'] = '';
							}
							if ( isset( $value['tdesignation'] ) ) {
								$value['tdesignation'] = '';
							}
							$final_default[] = $value;
						}
					}

				}


				$field['sections']['section']['fields']['testimonials']['default'] = $final_default;
			}


			return $field;
		}

		function add_custom_cls( $body_class ) {

			$wfacp_id = $this->wfacp_id;
			if ( isset( $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['make_button_sticky_on_mobile'] ) ) {
				$wfacp_body_class[] = $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['make_button_sticky_on_mobile'];
			}
			$is_default_checkout = get_post_meta( $wfacp_id, 'is_default_checkout', true );

			if ( ( isset( $is_default_checkout ) && $is_default_checkout == 1 ) ) {


				$body_class[] = 'wfacp_default_created';
			}
			if ( WFACP_Core()->pay->is_order_pay() ) {
				$body_class[] = 'woocommerce-order-pay';
			}

			return $body_class;

		}


		public function get_form_data() {

			$form_data = isset( $this->customizer_fields_data['wfacp_form'] ) ? $this->customizer_fields_data['wfacp_form'] : [];

			return $form_data;
		}

		public function get_heading_title_class() {


			$form_data = $this->get_form_data();


			if ( isset( $form_data['border']['form_head']['border-style'] ) && '' != $form_data['border']['form_head']['border-style'] ) {

				return trim( $form_data['border']['form_head']['border-style'] );
			}

			return '';
		}

		public function get_heading_class() {

			$heading_talign      = '';
			$heading_font_weight = '';
			$form_data           = $this->get_form_data();
			if ( isset( $form_data['heading_section']['heading_talign'] ) ) {
				$heading_talign = $form_data['heading_section']['heading_talign'];
			}

			if ( isset( $form_data['heading_section']['heading_talign'] ) ) {
				$heading_font_weight = $form_data['heading_section']['heading_font_weight'];
			}

			return $heading_font_weight . ' ' . $heading_talign;
		}

		public function get_sub_heading_class() {
			$sub_heading_talign      = '';
			$sub_heading_font_weight = '';
			$form_data               = isset( $this->customizer_fields_data['wfacp_form'] ) ? $this->customizer_fields_data['wfacp_form'] : [];

			if ( isset( $form_data['sub_heading_section']['heading_talign'] ) ) {
				$sub_heading_talign = $form_data['sub_heading_section']['heading_talign'];
			}
			if ( isset( $form_data['sub_heading_section']['heading_font_weight'] ) ) {
				$sub_heading_font_weight = $form_data['sub_heading_section']['heading_font_weight'];
			}

			return $sub_heading_talign . ' ' . $sub_heading_font_weight;

		}

		public function get_payment_desc() {
			$form_data = $this->get_form_data();
			if ( isset( $form_data['form_data']['text_below_placeorder_btn'] ) && $form_data['form_data']['text_below_placeorder_btn'] != '' ) {
				return trim( $form_data['form_data']['text_below_placeorder_btn'] );
			}

			return '';

		}

		public function payment_heading() {

			$form_data = $this->get_form_data();
			if ( isset( $form_data['form_data']['payment_methods_heading'] ) && $form_data['form_data']['payment_methods_heading'] != '' ) {
				return trim( $form_data['form_data']['payment_methods_heading'] );
			}

			return '';

		}

		public function payment_sub_heading() {
			$form_data = $this->get_form_data();
			if ( isset( $form_data['form_data']['payment_methods_sub_heading'] ) && $form_data['form_data']['payment_methods_sub_heading'] != '' ) {
				return trim( $form_data['form_data']['payment_methods_sub_heading'] );
			}

			return '';
		}

		public function display_next_button( $step, $current_step ) {
			$form_data = $this->get_form_data();
			if ( 'single_step' != $current_step && ( is_array( $form_data ) && count( $form_data ) ) ) {

				$this->get_next_button( $step, $form_data );

			}

		}

		public function payment_button_alignment() {
			$form_data = $this->get_form_data();
			if ( isset( $form_data['btn_details']['talign'] ) && '' !== $form_data['btn_details']['talign'] ) {
				return trim( $form_data['btn_details']['talign'] );
			}

			return parent::payment_button_alignment();
		}

		public function customizer_layout_order( $panel_details, $section_key ) {

			return $panel_details;
		}

		public function get_mobile_mini_cart_collapsible_title() {

			if ( isset( $this->customizer_fields_data['wfacp_form']['form_data']['cart_collapse_title'] ) && '' !== $this->customizer_fields_data['wfacp_form']['form_data']['cart_collapse_title'] ) {
				return $this->customizer_fields_data['wfacp_form']['form_data']['cart_collapse_title'];
			}

			return parent::get_mobile_mini_cart_collapsible_title();

		}

		public function get_mobile_mini_cart_expand_title() {
			if ( isset( $this->customizer_fields_data['wfacp_form']['form_data']['cart_expanded_title'] ) && '' !== $this->customizer_fields_data['wfacp_form']['form_data']['cart_expanded_title'] ) {
				return $this->customizer_fields_data['wfacp_form']['form_data']['cart_expanded_title'];
			}

			return parent::get_mobile_mini_cart_expand_title();

		}

		public function enable_collapsed_coupon_field() {


			if ( isset( $this->customizer_fields_data['wfacp_form']['form_data']['enable_coupon'] ) && '' !== $this->customizer_fields_data['wfacp_form']['form_data']['enable_coupon'] ) {
				$enablecoupon = $this->customizer_fields_data['wfacp_form']['form_data']['enable_coupon'];

				return $enablecoupon;

			}

			return parent::enable_collapsed_coupon_field();

		}

		public function collapse_enable_coupon_collapsible() {


			if ( isset( $this->customizer_fields_data['wfacp_form']['form_data']['enable_coupon_collapsible'] ) && '' !== $this->customizer_fields_data['wfacp_form']['form_data']['enable_coupon_collapsible'] ) {
				$collapse_enable_coupon_collapsible = $this->customizer_fields_data['wfacp_form']['form_data']['enable_coupon_collapsible'];

				return $collapse_enable_coupon_collapsible;
			}

			return parent::collapse_enable_coupon_collapsible();

		}

		public function enable_coupon_right_side_coupon() {


			if ( isset( $this->customizer_fields_data['wfacp_form_cart']['form_data']['enable_coupon_right_side_coupon'] ) && '' !== $this->customizer_fields_data['wfacp_form_cart']['form_data']['enable_coupon_right_side_coupon'] ) {
				$enable_coupon_right_side_coupon = $this->customizer_fields_data['wfacp_form_cart']['form_data']['enable_coupon_right_side_coupon'];

				return $enable_coupon_right_side_coupon;
			}

			return parent::enable_coupon_right_side_coupon();

		}

		public function get_embed_localize_data() {

			$localData = [];
			if ( isset( $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['make_button_sticky_on_mobile'] ) ) {
				$make_button_sticky_on_mobile = $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['make_button_sticky_on_mobile'];
				if ( $make_button_sticky_on_mobile === 'yes_sticky' ) {
					$localData                                       = [];
					$localData['wfacp_make_button_sticky_on_mobile'] = 'yes';
				}

			}
			wp_localize_script( 'wfacp_checkout_js', 'wfacp_elementor_data', $localData );
		}


		public function display_image_in_collapsible_order_summary() {

			$selected_template_slug = $this->get_template_slug();

			$layout_key = '';
			if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
				$layout_key = $selected_template_slug . '_';
			}

			$order_hide_img = WFACP_Common::get_option( 'wfacp_order_summary_section_' . $layout_key . 'order_summary_hide_img' );

			$order_hide_img = isset( $order_hide_img ) ? $order_hide_img : false;

			if ( ( true === $order_hide_img || 1 === $order_hide_img ) && ! empty( $order_hide_img ) ) {

				return true;
			}


			return false;

		}

		public function print_empty_style_tag() {
			echo '<style data-type=\'wfacp\'></style>';
		}

		public function remove_built_in_title_tag( $status ) {

			remove_action( 'wp_head', '_wp_render_title_tag', 1 );

			return $status;
		}

		public function collapse_order_delete_item() {
			$order_delete_item = WFACP_Common::get_option( 'wfacp_form_cart_section_' . $this->get_template_slug() . '_order_delete_item' );

			return wc_string_to_bool( $order_delete_item );
		}

		public function collapse_order_quantity_switcher() {
			$show_quantity_switcher = WFACP_Common::get_option( 'wfacp_form_cart_section_' . $this->get_template_slug() . '_order_quantity_switcher' );

			return wc_string_to_bool( $show_quantity_switcher );
		}

		public function add_label_position_div() {
			$label_position = '';
			if ( isset( $this->customizer_fields_data['wfacp_form']['form_data']['label_position'] ) ) {
				$label_position = $this->customizer_fields_data['wfacp_form']['form_data']['label_position'];
			}

			echo "<div class=" . $label_position . ">";
		}

		public function close_label_position_div() {
			echo "</div>";
		}


	}
}