<?php

declare( strict_types=1 );

namespace cloudflare_purge_cache\includes\ui;


if ( ! class_exists( 'cloudflare_purge_cache\includes\ui\Cloudflare_Purge_Cache_Acf_Loader' ) ) {
	class Cloudflare_Purge_Cache_Acf_Loader {

		public function __construct() {
		}

		public function init(): void {
			match ( is_admin() ) {
				true => $this->load_acf(),
				default => false,
			};
		}

		private function load_acf(): void {
			if ( function_exists( 'acf_add_options_page' ) ) {
				acf_add_options_page( array(
					'page_title' => 'Cloudflare Settings',
					'menu_title' => 'Cloudflare',
					'menu_slug'  => 'cloudflare-settings',
					'capability' => 'manage_options',
					'redirect'   => true
				) );
			}


			if ( function_exists( 'acf_add_local_field_group' ) ) {

				acf_add_local_field_group( array(
					'key'                   => 'cloudflare_group',
					'title'                 => 'Cloudflare Settings',
					'fields'                => array(
						array(
							'key'      => 'cloudflare_cache_token_field',
							'label'    => 'Cloudflare Token',
							'name'     => 'cloudflare_cache_token',
							'type'     => 'password',
							'wpml_cf_preferences' => 1,
							'required' => 1,
						),
						array(
							'key'    => 'cloudflare_cache_zones_repeater_field',
							'label'  => 'Cloudflare Zones',
							'name'   => 'cloudflare_cache_zones',
							'wpml_cf_preferences' => 1,
							'type'   => 'repeater',
							'layout' => 'row',
						)
					),
					'location'              => array(
						array(
							array(
								'param'    => 'options_page',
								'operator' => '==',
								'value'    => 'cloudflare-settings',
							),
						),
					),
					'menu_order'            => 0,
					'position'              => 'normal',
					'style'                 => 'default',
					'label_placement'       => 'top',
					'instruction_placement' => 'label',
				) );

			}

			if ( function_exists( 'acf_add_local_field' ) ) {

				acf_add_local_field( array(
					'key'      => 'cloudflare_cache_zone_field',
					'label'    => 'Cloudflare Zone',
					'name'     => 'cloudflare_cache_zone',
					'type'     => 'text',
					'wpml_cf_preferences' => 1,
					'required' => 1,
					'parent'   => 'cloudflare_cache_zones_repeater_field'
				) );

			}

		}

	}
}