<?php

declare( strict_types=1 );

/*
Plugin Name: Cloudflare Purge Cache
Description: Plugin for init ACF options page and purge cloudflare cache by zones and opcache
Version: 1.1
Author: XayLoad
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'CLOUDFLARE_PURGE_CACHE_MANAGER_VERSION', '1.0.0' );

define( 'CLOUDFLARE_PURGE_CACHE_PLUGIN_FILE', __FILE__ );

define( 'CLOUDFLARE_PURGE_CACHE_PLUGIN_DIR', plugin_dir_path( CLOUDFLARE_PURGE_CACHE_PLUGIN_FILE ) );

require_once CLOUDFLARE_PURGE_CACHE_PLUGIN_DIR . 'includes/class-cloudflare-purge-cache-deactivator.php';

register_deactivation_hook(__FILE__, ['cloudflare_purge_cache\includes\Class_Cloudflare_Purge_Cache_Deactivator', 'deactivate']);

require_once CLOUDFLARE_PURGE_CACHE_PLUGIN_DIR . 'includes/class-cloudflare-purge-cache-core.php';
require_once CLOUDFLARE_PURGE_CACHE_PLUGIN_DIR . 'includes/ui/class-cloudflare-purge-cache-acf-loader.php';
require_once CLOUDFLARE_PURGE_CACHE_PLUGIN_DIR . 'includes/class-cloudflare-purge-cache-loader.php';

function cloudflare_purge_cache_init(): void
{
	\cloudflare_purge_cache\includes\Cloudflare_Purge_Cache_Loader::init();
}

cloudflare_purge_cache_init();
