<?php
/**
 * Management API
 *
 * The version of the OpenAPI document: 3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\Management;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\Management\ObjectSerializer;

class WebhooksMerchantLevelApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * WebhooksMerchantLevelApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://management-test.adyen.com/v3");
    }

    /**
    * Generate an HMAC key
    *
    * @param string $merchantId
    * @param string $webhookId
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\GenerateHmacKeyResponse
    * @throws AdyenException
    */
    public function generateHmacKey(string $merchantId, string $webhookId, array $requestOptions = null): \Adyen\Model\Management\GenerateHmacKeyResponse
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}', '{webhookId}'], [$merchantId, $webhookId], "/merchants/{merchantId}/webhooks/{webhookId}/generateHmac");
        $response = $this->requestHttp($endpoint, strtolower('POST'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\GenerateHmacKeyResponse::class);
    }

    /**
    * Get a webhook
    *
    * @param string $merchantId
    * @param string $webhookId
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\Webhook
    * @throws AdyenException
    */
    public function getWebhook(string $merchantId, string $webhookId, array $requestOptions = null): \Adyen\Model\Management\Webhook
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}', '{webhookId}'], [$merchantId, $webhookId], "/merchants/{merchantId}/webhooks/{webhookId}");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\Webhook::class);
    }

    /**
    * List all webhooks
    *
    * @param string $merchantId
    * @param array|null $requestOptions ['queryParams' => ['pageNumber'=> int, 'pageSize'=> int]]
    * @return \Adyen\Model\Management\ListWebhooksResponse
    * @throws AdyenException
    */
    public function listAllWebhooks(string $merchantId, array $requestOptions = null): \Adyen\Model\Management\ListWebhooksResponse
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}'], [$merchantId], "/merchants/{merchantId}/webhooks");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\ListWebhooksResponse::class);
    }

    /**
    * Remove a webhook
    *
    * @param string $merchantId
    * @param string $webhookId
    * @param array|null $requestOptions

    * @throws AdyenException
    */
    public function removeWebhook(string $merchantId, string $webhookId, array $requestOptions = null)
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}', '{webhookId}'], [$merchantId, $webhookId], "/merchants/{merchantId}/webhooks/{webhookId}");
        $this->requestHttp($endpoint, strtolower('DELETE'), null, $requestOptions);
    }

    /**
    * Set up a webhook
    *
    * @param string $merchantId
    * @param \Adyen\Model\Management\CreateMerchantWebhookRequest $createMerchantWebhookRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\Webhook
    * @throws AdyenException
    */
    public function setUpWebhook(string $merchantId, \Adyen\Model\Management\CreateMerchantWebhookRequest $createMerchantWebhookRequest, array $requestOptions = null): \Adyen\Model\Management\Webhook
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}'], [$merchantId], "/merchants/{merchantId}/webhooks");
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $createMerchantWebhookRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\Webhook::class);
    }

    /**
    * Test a webhook
    *
    * @param string $merchantId
    * @param string $webhookId
    * @param \Adyen\Model\Management\TestWebhookRequest $testWebhookRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\TestWebhookResponse
    * @throws AdyenException
    */
    public function testWebhook(string $merchantId, string $webhookId, \Adyen\Model\Management\TestWebhookRequest $testWebhookRequest, array $requestOptions = null): \Adyen\Model\Management\TestWebhookResponse
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}', '{webhookId}'], [$merchantId, $webhookId], "/merchants/{merchantId}/webhooks/{webhookId}/test");
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $testWebhookRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\TestWebhookResponse::class);
    }

    /**
    * Update a webhook
    *
    * @param string $merchantId
    * @param string $webhookId
    * @param \Adyen\Model\Management\UpdateMerchantWebhookRequest $updateMerchantWebhookRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\Webhook
    * @throws AdyenException
    */
    public function updateWebhook(string $merchantId, string $webhookId, \Adyen\Model\Management\UpdateMerchantWebhookRequest $updateMerchantWebhookRequest, array $requestOptions = null): \Adyen\Model\Management\Webhook
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}', '{webhookId}'], [$merchantId, $webhookId], "/merchants/{merchantId}/webhooks/{webhookId}");
        $response = $this->requestHttp($endpoint, strtolower('PATCH'), (array) $updateMerchantWebhookRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\Webhook::class);
    }
}
