<?php
/**
 * Management API
 *
 * The version of the OpenAPI document: 3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\Management;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\Management\ObjectSerializer;

class TerminalActionsCompanyLevelApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * TerminalActionsCompanyLevelApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://management-test.adyen.com/v3");
    }

    /**
    * Get terminal action
    *
    * @param string $companyId
    * @param string $actionId
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\ExternalTerminalAction
    * @throws AdyenException
    */
    public function getTerminalAction(string $companyId, string $actionId, array $requestOptions = null): \Adyen\Model\Management\ExternalTerminalAction
    {
        $endpoint = $this->baseURL . str_replace(['{companyId}', '{actionId}'], [$companyId, $actionId], "/companies/{companyId}/terminalActions/{actionId}");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\ExternalTerminalAction::class);
    }

    /**
    * Get a list of terminal actions
    *
    * @param string $companyId
    * @param array|null $requestOptions ['queryParams' => ['pageNumber'=> int, 'pageSize'=> int, 'status'=> string, 'type'=> string]]
    * @return \Adyen\Model\Management\ListExternalTerminalActionsResponse
    * @throws AdyenException
    */
    public function listTerminalActions(string $companyId, array $requestOptions = null): \Adyen\Model\Management\ListExternalTerminalActionsResponse
    {
        $endpoint = $this->baseURL . str_replace(['{companyId}'], [$companyId], "/companies/{companyId}/terminalActions");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\ListExternalTerminalActionsResponse::class);
    }
}
