<?php

declare(strict_types=1);

namespace CrippleCrew\AdyenLite;

use Adyen\Util\HmacSignature;
use WC_Order;

class WebhookHandler
{

    public function __construct(private string $hmacKey)
    {
    }

    public function handle(array $item): void
    {
        // 1 — проверка подписи
        $validator = new HmacSignature();
        if (!$validator->isValidNotificationHMAC($this->hmacKey, $item)) {
            return;
        }

        $order = wc_get_order($item['merchantReference'] ?? 0);
        if (!$order) {
            return;
        }

        switch ($item['eventCode']) {
            case 'AUTHORISATION':
                if ($item['success'] === 'true') {
                    $order->payment_complete($item['pspReference']);
                } else {
                    $order->update_status('failed', 'Adyen authorisation failed');
                }
                break;

            case 'REFUND':
                $order->update_status('refunded', 'Refunded via Adyen');
                break;
        }
    }
}
