<?php

namespace CrippleCrew\AdyenLite;

class Ajax
{
    public static function create_session()
    {
        if (WC()->cart->is_empty()) {
            wp_send_json_error('empty cart');
        }
        $settings = get_option('woocommerce_adyen_lite_settings', []);

        try{
            $svc = new AdyenLiteService([
                'api_key'          => $settings['api_key'] ?? '',
                'merchant_account' => $settings['merchant_account'] ?? '',
                'test_mode'        => ($settings['test_mode'] ?? 'yes') === 'yes',
            ]);
        } catch (\Exception $exception){
            wp_send_json_error($exception->getMessage());
        }

        try {
            $session = $svc->createSessionFromCart('cart-' . time());
            wp_send_json_success($session);
        } catch (\Throwable $e) {
            wp_send_json_error($e->getMessage());
        }

        wp_die();
    }

    public function ajax_process_payment() {
        $order_id = absint($_POST['order_id']);
        $pmData   = $_POST['paymentMethod'];

        $settings = get_option('woocommerce_adyen_lite_settings', []);
        try {
            $svc = new AdyenLiteService([
                'api_key'          => $settings['api_key'] ?? '',
                'merchant_account' => $settings['merchant_account'] ?? '',
                'test_mode'        => ($settings['test_mode'] ?? 'yes') === 'yes',
            ]);
            $result = $svc->makePayment($order_id, $pmData);
            // makePayment internally calls PaymentsApi->payments(...)
            wp_send_json_success($result);
        } catch (\Throwable $e) {
            wp_send_json_error($e->getMessage());
        }
    }
}
