(function ($) {
    if (window.adyen_lite_loaded || !window.wc_adyen_lite) return;
    window.adyen_lite_loaded = true;

    const {session_url, clientKey} = wc_adyen_lite;
    const $wrapper = $('#adyen-card-container');
    if (!$wrapper.length) return;

    let sessionData = null;
    let cardComponent = null;

    function isAdyenSelected() {
        return $('input[name="payment_method"]:checked').val() === 'adyen_lite';
    }

    function refreshButtonAndHandler() {
        const $btn = $('#place_order');
        // unbind our submit override every time
        $('form.checkout').off('submit.adyen');

        if (isAdyenSelected()) {
            $btn.prop('disabled', true);
            // intercept
            $('form.checkout').on('submit', function (e) {
                e.preventDefault();
                cardComponent.submit();
            });
        } else {
            // other gateway: restore default
            $btn.prop('disabled', false);
        }
    }


    function createSessionAndInit() {
        $.post(session_url, {})
            .done(resp => {
                if (!resp.success) return;
                sessionData = resp.data;
                initDropin(sessionData);
            })
            .fail(xhr => console.error('AJAX error', xhr));
    }

    async function initDropin(sessionObj) {
        try {
            const checkout = await AdyenCheckout({
                environment: 'test',   // или 'live'
                clientKey,
                session: sessionObj,
                showPayButton: false
            });
            cardComponent = checkout
                .create('card', {
                        hasHolderName: true,
                        holderNameRequired: true,
                        onChange: state => {
                            if (isAdyenSelected()) {
                                $('#place_order').prop('disabled', !state.isValid);
                            }
                            if (state.isValid) {
                                $('#adyen-payment-data').val(
                                    JSON.stringify(state.data.paymentMethod)
                                );
                            }
                        },
                    },
                )

            cardComponent.mount('#adyen-card-container');
        } catch (e) {
            console.error('Adyen init failed', e);
        }
    }

    $(document.body).one('updated_checkout', createSessionAndInit);

    $(document.body).on('updated_checkout', function () {
        refreshButtonAndHandler();
    });

    $(document.body).on('payment_method_selected', function (e, method) {
        if (method === 'adyen_lite') {
            $(document.body).one('updated_checkout', createSessionAndInit);
        }

        refreshButtonAndHandler()
    });


})(jQuery);
